/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import io.sentry.Sentry;
import io.sentry.protocol.User;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import net.technicpack.autoupdate.IBuildNumber;
import net.technicpack.autoupdate.Relauncher;
import net.technicpack.discord.CachedDiscordApi;
import net.technicpack.discord.HttpDiscordApi;
import net.technicpack.discord.IDiscordApi;
import net.technicpack.launcher.autoupdate.CommandLineBuildNumber;
import net.technicpack.launcher.autoupdate.VersionFileBuildNumber;
import net.technicpack.launcher.io.TechnicAvatarMapper;
import net.technicpack.launcher.io.TechnicFaceMapper;
import net.technicpack.launcher.io.TechnicInstalledPackStore;
import net.technicpack.launcher.io.TechnicLauncherDirectories;
import net.technicpack.launcher.io.TechnicUserStore;
import net.technicpack.launcher.launch.Installer;
import net.technicpack.launcher.settings.SettingsFactory;
import net.technicpack.launcher.settings.StartupParameters;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.settings.migration.IMigrator;
import net.technicpack.launcher.settings.migration.InitialV3Migrator;
import net.technicpack.launcher.settings.migration.ResetJvmArgsIfDefaultString;
import net.technicpack.launcher.ui.InstallerFrame;
import net.technicpack.launcher.ui.LauncherFrame;
import net.technicpack.launcher.ui.LoginFrame;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.components.discover.DiscoverInfoPanel;
import net.technicpack.launcher.ui.components.modpacks.ModpackSelector;
import net.technicpack.launchercore.TechnicConstants;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.auth.UserModel;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.launchercore.image.face.MinotarFaceImageStore;
import net.technicpack.launchercore.image.face.WebAvatarImageStore;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.launchercore.install.ModpackInstaller;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.launch.java.source.FileJavaSource;
import net.technicpack.launchercore.launch.java.source.InstalledJavaSource;
import net.technicpack.launchercore.logging.BuildLogFormatter;
import net.technicpack.launchercore.logging.ConsoleHandler;
import net.technicpack.launchercore.logging.ConsoleLogFormatter;
import net.technicpack.launchercore.logging.LoggerOutputStream;
import net.technicpack.launchercore.logging.RotatingFileHandler;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.PackLoader;
import net.technicpack.launchercore.modpacks.resources.PackImageStore;
import net.technicpack.launchercore.modpacks.resources.PackResourceMapper;
import net.technicpack.launchercore.modpacks.resources.resourcetype.BackgroundResourceType;
import net.technicpack.launchercore.modpacks.resources.resourcetype.IconResourceType;
import net.technicpack.launchercore.modpacks.resources.resourcetype.LogoResourceType;
import net.technicpack.minecraftcore.launch.MinecraftLauncher;
import net.technicpack.minecraftcore.microsoft.auth.MicrosoftAuthenticator;
import net.technicpack.platform.PlatformPackInfoRepository;
import net.technicpack.platform.cache.ModpackCachePlatformApi;
import net.technicpack.platform.http.HttpPlatformApi;
import net.technicpack.platform.http.HttpPlatformSearchApi;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.solder.SolderPackSource;
import net.technicpack.solder.cache.CachedSolderApi;
import net.technicpack.solder.http.HttpSolderApi;
import net.technicpack.ui.components.ConsoleFrame;
import net.technicpack.ui.controls.installation.SplashScreen;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.JavaUtils;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;

public class LauncherMain {
    private static final Locale[] supportedLanguages = new Locale[]{Locale.ENGLISH, Locale.forLanguageTag("pt-BR"), Locale.forLanguageTag("pt-PT"), Locale.forLanguageTag("cs"), Locale.GERMAN, Locale.FRENCH, Locale.ITALIAN, Locale.forLanguageTag("hu"), Locale.forLanguageTag("pl"), Locale.CHINA, Locale.TAIWAN, Locale.forLanguageTag("nl-NL"), Locale.forLanguageTag("sk")};
    private static ConsoleFrame consoleFrame;
    private static IBuildNumber buildNumber;

    public static void main(String[] argv) {
        try {
            Toolkit.getDefaultToolkit().getDesktopProperty("dummy");
        }
        catch (Exception e) {
            Sentry.captureException(e);
        }
        LauncherMain.runHeadlessCheck();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            Utils.getLogger().log(Level.SEVERE, "Failed to set system look and feel", ex);
        }
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        StartupParameters params = new StartupParameters(argv);
        try {
            JCommander jc = JCommander.newBuilder().addObject(params).build();
            jc.setCaseSensitiveOptions(false);
            jc.setAcceptUnknownOptions(true);
            jc.parse(argv);
        }
        catch (ParameterException ex) {
            ex.printStackTrace();
        }
        TechnicSettings settings = SettingsFactory.buildSettingsObject(Relauncher.getRunningPath(LauncherMain.class), params.isMover());
        if (settings == null) {
            LauncherMain.showSetupWindow(params);
            return;
        }
        User sentryUser = new User();
        sentryUser.setId(settings.getClientId());
        Sentry.setUser(sentryUser);
        TechnicLauncherDirectories directories = new TechnicLauncherDirectories(settings.getTechnicRoot());
        ResourceLoader resources = new ResourceLoader(directories, "net", "technicpack", "launcher", "resources");
        resources.setSupportedLanguages(supportedLanguages);
        resources.setLocale(settings.getLanguageCode());
        LauncherMain.checkIfRunningInsideOneDrive(directories.getLauncherDirectory());
        buildNumber = params.getBuildNumber() != null && !params.getBuildNumber().isEmpty() ? new CommandLineBuildNumber(params) : new VersionFileBuildNumber(resources);
        Sentry.configureScope(scope -> {
            scope.setTag("buildNumber", buildNumber.getBuildNumber());
            scope.setTag("updateStream", settings.getBuildStream());
        });
        TechnicConstants.setBuildNumber(buildNumber);
        LauncherMain.setupLogging(directories, resources);
        boolean displayConsole = settings.getShowConsole();
        if (displayConsole) {
            EventQueue.invokeLater(() -> LauncherMain.setConsoleVisible(true));
        }
        int build = -1;
        try {
            build = Integer.parseInt(buildNumber.getBuildNumber());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LauncherMain.runStartupDebug();
        LauncherMain.updateJavaTrustStore();
        LauncherMain.startLauncher(settings, params, directories, resources);
    }

    private static void runHeadlessCheck() {
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Technic Launcher cannot run in headless mode. Please run it in a graphical environment.");
            System.exit(1);
        }
    }

    private static void showStartupError(ResourceLoader resources, String message) {
        JOptionPane.showMessageDialog(null, message, resources.getString("updater.error.title", new String[0]), 0);
    }

    public static void setConsoleVisible(boolean visible) {
        if (consoleFrame != null) {
            consoleFrame.setVisible(visible);
        }
    }

    private static void showSetupWindow(StartupParameters params) {
        ResourceLoader installerResources = new ResourceLoader(null, "net", "technicpack", "launcher", "resources");
        installerResources.setSupportedLanguages(supportedLanguages);
        installerResources.setLocale("default");
        InstallerFrame dialog = new InstallerFrame(installerResources, params);
        dialog.setVisible(true);
    }

    private static void checkIfRunningInsideOneDrive(File launcherRoot) {
        if (OperatingSystem.getOperatingSystem() != OperatingSystem.WINDOWS) {
            return;
        }
        Path launcherRootPath = launcherRoot.toPath();
        for (String varName : new String[]{"OneDrive", "OneDriveConsumer"}) {
            Path oneDrivePath;
            String varValue = System.getenv(varName);
            if (varValue == null || varValue.isEmpty() || !launcherRootPath.startsWith(oneDrivePath = new File(varValue).toPath())) continue;
            JOptionPane.showMessageDialog(null, "Technic Launcher cannot run inside OneDrive. Please move it out of OneDrive, in the launcher settings.", "Cannot run inside OneDrive", 0);
        }
    }

    private static void setupLogging(LauncherDirectories directories, ResourceLoader resources) {
        System.out.println("Setting up logging");
        Logger logger = Utils.getLogger();
        File logDirectory = directories.getLogsDirectory();
        File logs = new File(logDirectory, "techniclauncher_%s.log");
        RotatingFileHandler fileHandler = new RotatingFileHandler(logs.getPath());
        fileHandler.setFormatter(new BuildLogFormatter(buildNumber.getBuildNumber()));
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.setUseParentHandlers(false);
        logger.addHandler(fileHandler);
        consoleFrame = new ConsoleFrame(2500, resources.getImage("icon.png"));
        ConsoleHandler consoleHandler = new ConsoleHandler(consoleFrame);
        consoleHandler.setFormatter(new ConsoleLogFormatter());
        logger.addHandler(consoleHandler);
        System.setOut(new PrintStream(new LoggerOutputStream(Level.INFO, logger), true));
        System.setErr(new PrintStream(new LoggerOutputStream(Level.SEVERE, logger), true));
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            e.printStackTrace();
            logger.log(Level.SEVERE, String.format("Unhandled exception in thread %s", t), e);
            Sentry.captureException(e);
        });
    }

    private static void runStartupDebug() {
        Utils.getLogger().info(String.format("OS: %s", System.getProperty("os.name").toLowerCase(Locale.ROOT)));
        Utils.getLogger().info(String.format("Identified as %s", OperatingSystem.getOperatingSystem().getName()));
        Utils.getLogger().info(String.format("Java: %s %s-bit (%s)", System.getProperty("java.version"), JavaUtils.JAVA_BITNESS, JavaUtils.OS_ARCH));
        String[] domains = new String[]{"minecraft.net", "session.minecraft.net", "textures.minecraft.net", "libraries.minecraft.net", "account.mojang.com", "www.technicpack.net", "launcher.technicpack.net", "api.technicpack.net", "mirror.technicpack.net", "solder.technicpack.net", "files.minecraftforge.net", "user.auth.xboxlive.com", "xsts.auth.xboxlive.com", "api.minecraftservices.com", "launchermeta.mojang.com", "piston-meta.mojang.com"};
        CompletableFuture[] dnsFutures = (CompletableFuture[])Arrays.stream(domains).map(domain -> CompletableFuture.runAsync(() -> {
            try {
                String ips = Arrays.stream(InetAddress.getAllByName(domain)).map(InetAddress::getHostAddress).collect(Collectors.joining(", "));
                Utils.getLogger().info(String.format("%s resolves to [%s]", domain, ips));
            }
            catch (UnknownHostException ex) {
                Utils.getLogger().log(Level.SEVERE, String.format("Failed to resolve %s: %s", domain, ex));
            }
        })).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(dnsFutures).join();
    }

    private static String getCertificateFingerprint(Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02X:", b));
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            Utils.getLogger().log(Level.WARNING, "Failed to get certificate fingerprint", e);
            return "unknown";
        }
    }

    private static void updateJavaTrustStore() {
        String javaVersion = System.getProperty("java.version");
        if (JavaUtils.compareVersions(javaVersion, "1.8.0_141") >= 0) {
            Utils.getLogger().info(String.format("Don't need to update Java trust store; Java version is recent enough (%s)", javaVersion));
            return;
        }
        try {
            KeyStore defaultTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            Path defaultKsPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            try (InputStream is = Files.newInputStream(defaultKsPath, new OpenOption[0]);){
                defaultTrustStore.load(is, "changeit".toCharArray());
            }
            KeyStore technicTrustStore = KeyStore.getInstance("JKS");
            try (InputStream is = LauncherMain.class.getResourceAsStream("/net/technicpack/launcher/resources/technicKeystore.jks");){
                technicTrustStore.load(is, "technicrootca".toCharArray());
            }
            KeyStore mergedTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            mergedTrustStore.load(null, null);
            Enumeration<String> defaultAliases = defaultTrustStore.aliases();
            while (defaultAliases.hasMoreElements()) {
                String alias = defaultAliases.nextElement();
                Certificate cert = defaultTrustStore.getCertificate(alias);
                if (cert == null) {
                    Utils.getLogger().log(Level.WARNING, String.format("Certificate for alias '%s' in default trust store is null", alias));
                    continue;
                }
                mergedTrustStore.setCertificateEntry(alias, cert);
            }
            Enumeration<String> technicAliases = technicTrustStore.aliases();
            while (technicAliases.hasMoreElements()) {
                String alias = technicAliases.nextElement();
                Certificate cert = technicTrustStore.getCertificate(alias);
                if (cert == null) {
                    Utils.getLogger().log(Level.WARNING, String.format("Certificate for alias '%s' in Technic trust store is null", alias));
                    continue;
                }
                if (mergedTrustStore.containsAlias(alias)) continue;
                Utils.getLogger().log(Level.FINE, String.format("Adding certificate with alias '%s', fingerprint %s", alias, LauncherMain.getCertificateFingerprint(cert)));
                mergedTrustStore.setCertificateEntry(alias, cert);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(mergedTrustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            Utils.getLogger().log(Level.INFO, "Updated Java trust store with new root certificates successfully");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Utils.getLogger().log(Level.WARNING, "Failed to update Java trust store. Problems might happen with TLS connections", e);
        }
    }

    private static Thread createCleanupLogsThread(LauncherDirectories directories) {
        Thread cleanupLogsThread = new Thread(() -> {
            Iterator<File> files = FileUtils.iterateFiles(new File(directories.getLauncherDirectory(), "logs"), new String[]{"log"}, false);
            DateTime aWeekAgo = DateTime.now().minusWeeks(1);
            while (files.hasNext()) {
                File logFile = files.next();
                if (!logFile.exists() || !new DateTime(logFile.lastModified()).isBefore(aWeekAgo)) continue;
                logFile.delete();
            }
        });
        cleanupLogsThread.setDaemon(true);
        return cleanupLogsThread;
    }

    private static void startLauncher(TechnicSettings settings, StartupParameters startupParameters, LauncherDirectories directories, ResourceLoader resources) {
        UIManager.put("ComboBox.disabledBackground", UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        UIManager.put("ComboBox.disabledForeground", UIConstants.COLOR_GREY_TEXT);
        System.setProperty("xr.load.xml-reader", "org.ccil.cowan.tagsoup.Parser");
        Thread cleanupLogsThread = LauncherMain.createCleanupLogsThread(directories);
        cleanupLogsThread.start();
        SplashScreen splash = new SplashScreen(resources.getImage("launch_splash.png"), 0);
        Color bg = UIConstants.COLOR_FORM_ELEMENT_INTERNAL;
        splash.getContentPane().setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 255));
        splash.pack();
        splash.setLocationRelativeTo(null);
        splash.setVisible(true);
        JavaVersionRepository javaVersions = new JavaVersionRepository();
        new InstalledJavaSource().enumerateVersions(javaVersions);
        FileJavaSource javaVersionFile = FileJavaSource.load(new File(settings.getTechnicRoot(), "javaVersions.json"));
        javaVersionFile.enumerateVersions(javaVersions);
        javaVersions.selectVersion(settings.getJavaVersion(), settings.getPrefer64Bit());
        TechnicUserStore users = TechnicUserStore.load(new File(directories.getLauncherDirectory(), "users.json"));
        MicrosoftAuthenticator microsoftAuthenticator = new MicrosoftAuthenticator(new File(directories.getLauncherDirectory(), "oauth"));
        UserModel userModel = new UserModel(users, microsoftAuthenticator);
        IconResourceType iconType = new IconResourceType();
        LogoResourceType logoType = new LogoResourceType();
        BackgroundResourceType backgroundType = new BackgroundResourceType();
        PackResourceMapper iconMapper = new PackResourceMapper(directories, resources.getImage("icon.png"), iconType);
        ImageRepository<ModpackModel> iconRepo = new ImageRepository<ModpackModel>(iconMapper, new PackImageStore(iconType));
        ImageRepository<ModpackModel> logoRepo = new ImageRepository<ModpackModel>(new PackResourceMapper(directories, resources.getImage("modpack/ModImageFiller.png"), logoType), new PackImageStore(logoType));
        ImageRepository<ModpackModel> backgroundRepo = new ImageRepository<ModpackModel>(new PackResourceMapper(directories, null, backgroundType), new PackImageStore(backgroundType));
        ImageRepository<IUserType> skinRepo = new ImageRepository<IUserType>(new TechnicFaceMapper(directories, resources), new MinotarFaceImageStore("https://minotar.net/"));
        ImageRepository<AuthorshipInfo> avatarRepo = new ImageRepository<AuthorshipInfo>(new TechnicAvatarMapper(directories, resources), new WebAvatarImageStore());
        HttpSolderApi httpSolder = new HttpSolderApi(settings.getClientId());
        CachedSolderApi solder = new CachedSolderApi(directories, httpSolder, 3600);
        HttpPlatformApi httpPlatform = new HttpPlatformApi("https://api.technicpack.net/", buildNumber.getBuildNumber());
        ModpackCachePlatformApi platform = new ModpackCachePlatformApi(httpPlatform, 3600, directories);
        HttpPlatformSearchApi platformSearch = new HttpPlatformSearchApi("https://api.technicpack.net/", buildNumber.getBuildNumber());
        TechnicInstalledPackStore packStore = TechnicInstalledPackStore.load(new File(directories.getLauncherDirectory(), "installedPacks"));
        PlatformPackInfoRepository packInfoRepository = new PlatformPackInfoRepository(platform, solder);
        ArrayList<IMigrator> migrators = new ArrayList<IMigrator>(1);
        migrators.add(new InitialV3Migrator(platform));
        migrators.add(new ResetJvmArgsIfDefaultString());
        SettingsFactory.migrateSettings(settings, packStore, directories, users, migrators);
        PackLoader packList = new PackLoader(directories, packStore, packInfoRepository);
        ModpackSelector selector = new ModpackSelector(resources, packList, new SolderPackSource("https://solder.pokeland.cz/api/", solder), solder, platform, platformSearch, iconRepo);
        selector.setBorder(BorderFactory.createEmptyBorder());
        userModel.addAuthListener(selector);
        resources.registerResource(selector);
        DiscoverInfoPanel discoverInfoPanel = new DiscoverInfoPanel(resources, startupParameters.getDiscoverUrl(), platform, directories, selector);
        MinecraftLauncher launcher = new MinecraftLauncher(platform, directories, userModel, javaVersions, buildNumber);
        ModpackInstaller modpackInstaller = new ModpackInstaller(platform, settings.getClientId());
        Installer installer = new Installer(startupParameters, directories, modpackInstaller, launcher, settings, iconMapper);
        IDiscordApi discordApi = new HttpDiscordApi("https://discord.com/api");
        discordApi = new CachedDiscordApi(discordApi, 600, 60);
        LauncherFrame frame = new LauncherFrame(resources, skinRepo, userModel, settings, selector, iconRepo, logoRepo, backgroundRepo, installer, avatarRepo, platform, directories, packStore, startupParameters, discoverInfoPanel, javaVersions, javaVersionFile, buildNumber, discordApi);
        userModel.addAuthListener(frame);
        ActionListener listener = e -> {
            splash.dispose();
            if (settings.getLaunchToModpacks()) {
                frame.selectTab("modpacks");
            }
        };
        discoverInfoPanel.setLoadListener(listener);
        LoginFrame login = new LoginFrame(resources, settings, userModel, skinRepo);
        userModel.addAuthListener(login);
        userModel.addAuthListener(user -> {
            if (user == null) {
                splash.dispose();
            }
        });
        userModel.startupAuth();
        Utils.sendTracking("runLauncher", "run", buildNumber.getBuildNumber(), settings.getClientId());
    }
}

