/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.io;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.technicpack.launchercore.modpacks.InstalledPack;
import net.technicpack.launchercore.modpacks.sources.IInstalledPackRepository;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;

public class TechnicInstalledPackStore
implements IInstalledPackRepository {
    private transient File loadedFile;
    private final Map<String, InstalledPack> installedPacks = new HashMap<String, InstalledPack>();
    private final List<String> byIndex = new ArrayList<String>();
    private String selected = null;

    public TechnicInstalledPackStore(File jsonFile) {
        this.setLoadedFile(jsonFile);
    }

    public static TechnicInstalledPackStore load(File jsonFile) {
        if (!jsonFile.exists()) {
            Utils.getLogger().log(Level.WARNING, "Unable to load installedPacks from " + jsonFile + " because it does not exist.");
            return new TechnicInstalledPackStore(jsonFile);
        }
        try {
            String json = FileUtils.readFileToString(jsonFile, StandardCharsets.UTF_8);
            TechnicInstalledPackStore parsedList = Utils.getGson().fromJson(json, TechnicInstalledPackStore.class);
            if (parsedList != null) {
                parsedList.setLoadedFile(jsonFile);
                return parsedList;
            }
            return new TechnicInstalledPackStore(jsonFile);
        }
        catch (JsonSyntaxException | IOException e) {
            Utils.getLogger().log(Level.WARNING, "Unable to load installedPacks from " + jsonFile);
            return new TechnicInstalledPackStore(jsonFile);
        }
    }

    protected void setLoadedFile(File loadedFile) {
        this.loadedFile = loadedFile;
        this.installedPacks.remove("addpack");
        this.byIndex.remove("addpack");
    }

    @Override
    public Map<String, InstalledPack> getInstalledPacks() {
        return this.installedPacks;
    }

    @Override
    public List<String> getPackNames() {
        return this.byIndex;
    }

    @Override
    public String getSelectedSlug() {
        return this.selected;
    }

    @Override
    public void setSelectedSlug(String slug) {
        this.selected = slug;
        this.save();
    }

    @Override
    public InstalledPack put(InstalledPack installedPack) {
        InstalledPack pack = this.installedPacks.put(installedPack.getName(), installedPack);
        if (pack == null) {
            this.byIndex.add(installedPack.getName());
        }
        this.save();
        return pack;
    }

    @Override
    public InstalledPack remove(String name) {
        InstalledPack pack = this.installedPacks.remove(name);
        if (pack != null) {
            this.byIndex.remove(name);
        }
        this.save();
        return pack;
    }

    @Override
    public void save() {
        String json = Utils.getGson().toJson(this);
        File tmpFile = new File(this.loadedFile.getAbsolutePath() + ".tmp");
        try {
            FileUtils.writeStringToFile(tmpFile, json, StandardCharsets.UTF_8);
            if (this.loadedFile.exists() && !this.loadedFile.delete()) {
                throw new IOException("Failed to delete");
            }
            FileUtils.moveFile(tmpFile, this.loadedFile);
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.WARNING, "Unable to save settings " + this.loadedFile, e);
        }
    }
}

