/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.io;

import java.io.File;
import javax.swing.JOptionPane;
import net.technicpack.launchercore.install.LauncherDirectories;

public class TechnicLauncherDirectories
implements LauncherDirectories {
    private File workDir;

    public TechnicLauncherDirectories(File rootDir) {
        this.workDir = rootDir;
    }

    private void ensureDirectory(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            return;
        }
        if (dir.exists() && !dir.isDirectory() && !dir.delete()) {
            JOptionPane.showMessageDialog(null, "Failed to create directory " + dir.getAbsolutePath() + ".\nThis is a critical error, the launcher will terminate now.", "Critical error - Technic Launcher", 0);
            System.exit(1);
        }
        if (!dir.mkdirs()) {
            JOptionPane.showMessageDialog(null, "Failed to create directory " + dir.getAbsolutePath() + ".\nThis is a critical error, the launcher will terminate now.", "Critical error - Technic Launcher", 0);
            System.exit(1);
        }
    }

    @Override
    public File getLauncherDirectory() {
        this.ensureDirectory(this.workDir);
        return this.workDir;
    }

    @Override
    public File getCacheDirectory() {
        File cache = new File(this.getLauncherDirectory(), "cache");
        this.ensureDirectory(cache);
        return cache;
    }

    @Override
    public File getAssetsDirectory() {
        File assets = new File(this.getLauncherDirectory(), "assets");
        this.ensureDirectory(assets);
        return assets;
    }

    @Override
    public File getModpacksDirectory() {
        File modpacks = new File(this.getLauncherDirectory(), "modpacks");
        this.ensureDirectory(modpacks);
        return modpacks;
    }

    @Override
    public File getRuntimesDirectory() {
        File runtimes = new File(this.getLauncherDirectory(), "runtimes");
        this.ensureDirectory(runtimes);
        return runtimes;
    }

    @Override
    public File getLogsDirectory() {
        File logs = new File(this.getLauncherDirectory(), "logs");
        this.ensureDirectory(logs);
        return logs;
    }
}

