/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.settings;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.settings.migration.IMigrator;
import net.technicpack.launchercore.auth.IUserStore;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.launchercore.modpacks.sources.IInstalledPackRepository;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;

public class SettingsFactory {
    public static TechnicSettings buildSettingsObject(String runningDir, boolean isMover) {
        System.out.println("Settings for exe: " + runningDir);
        File portableSettingsDir = SettingsFactory.getPortableSettingsDir(runningDir, isMover);
        if (portableSettingsDir == null) {
            System.out.println("Portable settings dir has broken terribly");
        } else {
            System.out.println("Portable settings dir: " + portableSettingsDir.getAbsolutePath());
        }
        TechnicSettings portableSettings = SettingsFactory.tryGetSettings(portableSettingsDir);
        if (portableSettings != null && portableSettings.isPortable()) {
            System.out.println("Portable settings file found.");
            return portableSettings;
        }
        File installedSettingsDir = OperatingSystem.getOperatingSystem().getUserDirectoryForApp("technic");
        TechnicSettings settings = SettingsFactory.tryGetSettings(installedSettingsDir);
        return settings;
    }

    public static void migrateSettings(TechnicSettings settings, IInstalledPackRepository packStore, LauncherDirectories directories, IUserStore users, List<IMigrator> migrators) {
        for (IMigrator migrator : migrators) {
            boolean bothNull;
            String version = settings.getLauncherSettingsVersion();
            boolean bl = bothNull = version == null && migrator.getMigrationVersion() == null;
            if (!bothNull && (version == null || !version.equals(migrator.getMigrationVersion()))) continue;
            migrator.migrate(settings, packStore, directories, users);
            settings.setLauncherSettingsVersion(migrator.getMigratedVersion());
        }
        settings.save();
    }

    private static TechnicSettings tryGetSettings(File rootDir) {
        if (!rootDir.exists()) {
            return null;
        }
        File settingsFile = new File(rootDir, "settings.json");
        if (settingsFile == null || !settingsFile.exists()) {
            return null;
        }
        try {
            String json = FileUtils.readFileToString(settingsFile, StandardCharsets.UTF_8);
            TechnicSettings settings = Utils.getGson().fromJson(json, TechnicSettings.class);
            if (settings != null) {
                settings.setFilePath(settingsFile);
            }
            return settings;
        }
        catch (JsonSyntaxException | IOException e) {
            Utils.getLogger().log(Level.WARNING, "Unable to load version from " + settingsFile);
            return null;
        }
    }

    private static File getPortableSettingsDir(String runningDir, boolean isMover) {
        File runningFolder = new File(runningDir).getParentFile();
        if (isMover) {
            return runningFolder;
        }
        return new File(runningFolder, "technic");
    }
}

