/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.text.View;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.modpacks.RunData;
import net.technicpack.ui.controls.LauncherDialog;
import net.technicpack.ui.controls.RoundedButton;
import net.technicpack.ui.controls.borders.RoundBorder;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.DesktopUtils;
import net.technicpack.utilslib.Memory;

public class FixRunDataDialog
extends LauncherDialog {
    private static final int DIALOG_WIDTH = 620;
    private ResourceLoader resourceLoader;
    private RunData runData;
    private JavaVersionRepository javaVersionRepository;
    private Memory attemptedMemory;
    private boolean shouldAskFirst;
    private final boolean usingMojangJava;
    private IJavaRuntime recommendedVersion;
    private Memory recommendedMemory;
    private JCheckBox rememberThis;
    private Result result = Result.OK;
    private static JLabel resizer = new JLabel();

    public FixRunDataDialog(Frame owner, ResourceLoader resourceLoader, RunData runData, JavaVersionRepository javaVersionRepository, Memory attemptedMemory, boolean shouldAskFirst, boolean usingMojangJava) {
        super(owner);
        this.runData = runData;
        this.javaVersionRepository = javaVersionRepository;
        this.attemptedMemory = attemptedMemory;
        this.resourceLoader = resourceLoader;
        this.shouldAskFirst = shouldAskFirst;
        this.usingMojangJava = usingMojangJava;
        this.recommendSettings();
        this.initComponents();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.recommendedVersion != null && this.recommendedMemory != null && this.javaVersionRepository.getSelectedVersion().equals(this.recommendedVersion) && this.attemptedMemory.getMemoryMB() == this.recommendedMemory.getMemoryMB() || !this.shouldAskFirst && this.recommendedMemory != null && this.recommendedVersion != null) {
            this.result = Result.ACCEPT;
            this.dispose();
            return;
        }
        super.setVisible(visible);
    }

    public Result getResult() {
        return this.result;
    }

    public boolean shouldRemember() {
        if (this.rememberThis == null) {
            return false;
        }
        return this.rememberThis.isSelected();
    }

    public Memory getRecommendedMemory() {
        return this.recommendedMemory;
    }

    public IJavaRuntime getRecommendedJavaVersion() {
        return this.recommendedVersion;
    }

    protected void recommendSettings() {
        this.recommendedVersion = this.usingMojangJava ? null : (!this.runData.isJavaValid(this.javaVersionRepository.getSelectedVersion().getVersion()) ? this.runData.getValidJavaVersion(this.javaVersionRepository) : this.javaVersionRepository.getSelectedVersion());
        this.recommendedMemory = !this.runData.isMemoryValid(this.attemptedMemory.getMemoryMB()) ? this.runData.getValidMemory(this.javaVersionRepository) : this.attemptedMemory;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.createHeader(this.resourceLoader.getString("fixRunData.title", new String[0]));
        JPanel centerPanel = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.width = 620;
                return dim;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 620;
                return dim;
            }
        };
        centerPanel.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        centerPanel.setOpaque(true);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.add((Component)centerPanel, "Center");
        centerPanel.setLayout(new GridBagLayout());
        Font font = this.resourceLoader.getFont("OpenSans+Cyberbit.ttf", 16.0f);
        JLabel label = new JLabel("<html><body style=\"font-family:" + font.getFamily() + ";font-size:11px;font-color:#D0D0D0\">" + this.resourceLoader.getString("fixRunData.header", new String[0]) + "</body></html>");
        label.setFont(font);
        label.setForeground(UIConstants.COLOR_WHITE_TEXT);
        centerPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        label.setPreferredSize(this.getPreferredSize(label.getText(), 615));
        this.buildSuccessFailPanels(centerPanel, font.getFamily());
        boolean isFailure = this.recommendedMemory == null || !this.usingMojangJava && this.recommendedVersion == null;
        int gridBagIndex = 3;
        if (isFailure) {
            gridBagIndex = this.buildFailureReasons(centerPanel, gridBagIndex, font.getFamily());
        } else {
            label = new JLabel("<html><body style=\"font-family:" + font.getFamily() + ";font-size:11px;font-color:#D0D0D0\">" + this.resourceLoader.getString("fixRunData.changeSettings", new String[0]) + "</body></html>");
            label.setFont(font);
            label.setForeground(UIConstants.COLOR_WHITE_TEXT);
            centerPanel.add((Component)label, new GridBagConstraints(0, gridBagIndex++, 1, 1, 1.0, 0.0, 15, 1, new Insets(8, 0, 8, 0), 0, 0));
            label.setPreferredSize(this.getPreferredSize(label.getText(), 615));
        }
        JSeparator separator = new JSeparator();
        separator.setForeground(UIConstants.COLOR_REQUIREMENT_SEPARATOR);
        separator.setBackground(UIConstants.COLOR_REQUIREMENT_SEPARATOR);
        centerPanel.add((Component)separator, new GridBagConstraints(0, gridBagIndex++, 1, 1, 1.0, 0.0, 10, 2, new Insets(isFailure ? 14 : 0, 0, 0, 0), 0, 0));
        if (isFailure) {
            this.buildFailureButtons(centerPanel, gridBagIndex, font);
        } else {
            this.buildRecommendedButtons(centerPanel, gridBagIndex, font);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void createHeader(String text) {
        JPanel header = new JPanel();
        header.setBackground(Color.black);
        header.setLayout(new BoxLayout(header, 2));
        header.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.add((Component)header, "First");
        JLabel title = new JLabel(text);
        title.setFont(this.resourceLoader.getFont("Raleway+FireflySung.ttf", 26.0f));
        title.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        title.setForeground(UIConstants.COLOR_WHITE_TEXT);
        title.setOpaque(false);
        title.setIcon(this.resourceLoader.getIcon("options_cog.png"));
        header.add(title);
        header.add(Box.createHorizontalGlue());
        JButton closeButton = new JButton();
        closeButton.setIcon(this.resourceLoader.getIcon("close.png"));
        closeButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        closeButton.setContentAreaFilled(false);
        closeButton.setCursor(Cursor.getPredefinedCursor(12));
        closeButton.addActionListener(e -> this.closeDialog());
        closeButton.setFocusPainted(false);
        header.add(closeButton);
    }

    private void buildSuccessFailPanels(JPanel centerPanel, String fontFamily) {
        boolean memorySuccess = this.runData.isMemoryValid(this.attemptedMemory.getMemoryMB());
        boolean javaSuccess = this.usingMojangJava || this.runData.isJavaValid(this.javaVersionRepository.getSelectedVersion().getVersion());
        String memRequirement = this.resourceLoader.getString("fixRunData.reqMemory", this.runData.getMemoryObject().toString());
        String javaRequirement = this.resourceLoader.getString("fixRunData.reqJava", this.runData.getJava() == null ? "" : this.runData.getJava());
        String currentMem = this.resourceLoader.getString("fixRunData.currentMemory", this.attemptedMemory.toString());
        String currentJavaBitness = this.javaVersionRepository.getSelectedVersion().is64Bit() ? this.resourceLoader.getString("launcheroptions.java.64bit", new String[0]) : this.resourceLoader.getString("launcheroptions.java.32bit", new String[0]);
        String currentJava = this.resourceLoader.getString("fixRunData.currentJava", this.javaVersionRepository.getSelectedVersion().getVersion(), currentJavaBitness);
        if (!memorySuccess && this.recommendedMemory != null) {
            currentMem = currentMem + this.resourceLoader.getString("fixRunData.bestOption", this.recommendedMemory.toString());
        }
        if (!javaSuccess && this.recommendedVersion != null) {
            String javaBitness;
            String javaVersion = this.recommendedVersion.getVersion();
            String string = javaBitness = this.recommendedVersion.is64Bit() ? this.resourceLoader.getString("launcheroptions.java.64bit", new String[0]) : this.resourceLoader.getString("launcheroptions.java.32bit", new String[0]);
            if (this.javaVersionRepository.getBest64BitVersion() == this.recommendedVersion) {
                javaVersion = this.resourceLoader.getString("launcheroptions.java.best64version", javaVersion + " " + javaBitness);
            }
            currentJava = currentJava + this.resourceLoader.getString("fixRunData.bestOption", javaVersion);
        }
        this.addSuccessFailPanel(centerPanel, fontFamily, 1, memorySuccess, this.recommendedMemory != null, memRequirement, currentMem);
        this.addSuccessFailPanel(centerPanel, fontFamily, 2, javaSuccess, this.recommendedVersion != null, javaRequirement, currentJava);
    }

    private int buildFailureReasons(JPanel centerPanel, int gridBagIndex, String fontFamily) {
        boolean getMoreRam;
        JLabel label = new JLabel("<html><body style=\"font-family:" + fontFamily + ";font-size:11px;font-color:#D0D0D0\">" + this.resourceLoader.getString("fixRunData.cannotRun", new String[0]) + "</body></html>");
        label.setForeground(UIConstants.COLOR_WHITE_TEXT);
        centerPanel.add((Component)label, new GridBagConstraints(0, gridBagIndex++, 1, 1, 1.0, 0.0, 15, 1, new Insets(8, 0, 4, 0), 0, 0));
        label.setPreferredSize(this.getPreferredSize(label.getText(), 615));
        boolean javaVersionGood = this.usingMojangJava || this.recommendedVersion != null;
        boolean memoryGood = this.recommendedMemory != null;
        boolean requires64Bit = this.runData.getMemory() > 1024L;
        boolean has64Bit = this.javaVersionRepository.getBest64BitVersion() != null;
        boolean get64BitJava = requires64Bit && !has64Bit;
        boolean getBetterJava = !javaVersionGood && !get64BitJava;
        boolean bl = getMoreRam = !memoryGood && !get64BitJava;
        if (getBetterJava) {
            label = new JLabel("<html><head><style type=\"text/css\">a{color:#309aeb}body{font-family: " + fontFamily + ";font-size:11px;color:#D0D0D0}</style></head><body>" + this.resourceLoader.getString("fixRunData.needBetterJava", new String[0]) + "</body></html>", this.resourceLoader.getIcon("danger_icon.png"), 2);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DesktopUtils.browseUrl("https://api.adoptium.net/v3/installer/latest/21/ga/windows/x64/jre/hotspot/normal/eclipse?project=jdk");
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    FixRunDataDialog.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FixRunDataDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            label.setForeground(UIConstants.COLOR_WHITE_TEXT);
            centerPanel.add((Component)label, new GridBagConstraints(0, gridBagIndex++, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 8, 0, 0), 0, 0));
            label.setPreferredSize(this.getPreferredSize(label.getText(), 615));
        }
        if (get64BitJava) {
            label = new JLabel("<html><head><style type=\"text/css\">a{color:#309aeb}body{font-family:" + fontFamily + ";font-size:11px;color:#D0D0D0}</style></head><body><body style=\"font-family:" + fontFamily + ";font-size:11px;font-color:#D0D0D0\">" + this.resourceLoader.getString("fixRunData.need64BitJava", new String[0]) + "</body></html>", this.resourceLoader.getIcon("danger_icon.png"), 2);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DesktopUtils.browseUrl("https://api.adoptium.net/v3/installer/latest/21/ga/windows/x64/jre/hotspot/normal/eclipse?project=jdk");
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    FixRunDataDialog.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FixRunDataDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            label.setForeground(UIConstants.COLOR_WHITE_TEXT);
            centerPanel.add((Component)label, new GridBagConstraints(0, gridBagIndex++, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 8, 0, 0), 0, 0));
            label.setPreferredSize(this.getPreferredSize(label.getText(), 615));
        }
        if (getMoreRam) {
            label = new JLabel("<html><body style=\"font-family:" + fontFamily + ";font-size:11px;font-color:#D0D0D0\">" + this.resourceLoader.getString("fixRunData.needMoreRAM", new String[0]) + "</body></html>", this.resourceLoader.getIcon("danger_icon.png"), 2);
            label.setForeground(UIConstants.COLOR_WHITE_TEXT);
            centerPanel.add((Component)label, new GridBagConstraints(0, gridBagIndex++, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 8, 0, 0), 0, 0));
            label.setPreferredSize(this.getPreferredSize(label.getText(), 615));
        }
        return gridBagIndex;
    }

    private void addSuccessFailPanel(JPanel centerPanel, String fontFamily, int gridBagRow, boolean isSuccess, boolean hasRecommendation, String compareText, String contrastText) {
        JPanel successFailPanel = new JPanel();
        successFailPanel.setBorder(new RoundBorder(this.getPanelColor(isSuccess, hasRecommendation)));
        successFailPanel.setBackground(this.getPanelColor(isSuccess, hasRecommendation));
        centerPanel.add((Component)successFailPanel, new GridBagConstraints(0, gridBagRow, 1, 1, 1.0, 0.0, 10, 1, new Insets(8, 0, 10, 0), 0, 0));
        successFailPanel.setLayout(new GridBagLayout());
        JLabel checkbox = new JLabel(this.resourceLoader.getIcon(this.getPanelIcon(isSuccess, hasRecommendation)));
        successFailPanel.add((Component)checkbox, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 14, 0, 0), 0, 0));
        JLabel label = new JLabel("<html><body style=\"font-family:" + fontFamily + ";font-size:12px;font-color:#D0D0D0\">" + compareText + "</body></html>");
        label.setForeground(UIConstants.COLOR_WHITE_TEXT);
        successFailPanel.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(8, 10, 6, 0), 0, 0));
        label.setPreferredSize(this.getPreferredSize(label.getText(), 495));
        label = new JLabel("<html><body style=\"font-family:" + fontFamily + ";font-size:12px;font-color:#D0D0D0\">" + contrastText + "</body></html>");
        label.setForeground(UIConstants.COLOR_WHITE_TEXT);
        successFailPanel.add((Component)label, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 10, 8, 0), 0, 0));
        label.setPreferredSize(this.getPreferredSize(label.getText(), 495));
    }

    private void buildFailureButtons(JPanel centerPanel, int gridBagIndex, Font font) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        centerPanel.add((Component)buttonPanel, new GridBagConstraints(0, gridBagIndex++, 1, 1, 1.0, 1.0, 11, 1, new Insets(8, 0, 0, 0), 0, 0));
        RoundedButton okButton = new RoundedButton(this.resourceLoader.getString("fixRunData.OK", new String[0]));
        okButton.setFont(this.resourceLoader.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        okButton.setContentAreaFilled(false);
        okButton.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 25));
        okButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        okButton.setHoverForeground(UIConstants.COLOR_BLUE);
        okButton.addActionListener(e -> {
            this.result = Result.OK;
            this.dispose();
        });
        buttonPanel.add(okButton);
    }

    private void buildRecommendedButtons(JPanel centerPanel, int gridBagIndex, Font font) {
        JPanel checkPanel = new JPanel();
        checkPanel.setOpaque(false);
        centerPanel.add((Component)checkPanel, new GridBagConstraints(0, gridBagIndex++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel label = new JLabel(this.resourceLoader.getString("fixRunData.dontAskAgain", new String[0]));
        label.setFont(font);
        label.setForeground(UIConstants.COLOR_WHITE_TEXT);
        checkPanel.add(label);
        this.rememberThis = new JCheckBox("", false);
        this.rememberThis.setHorizontalAlignment(4);
        this.rememberThis.setBorder(BorderFactory.createEmptyBorder());
        this.rememberThis.setIconTextGap(0);
        this.rememberThis.setSelectedIcon(this.resourceLoader.getIcon("checkbox_closed.png"));
        this.rememberThis.setIcon(this.resourceLoader.getIcon("checkbox_open.png"));
        this.rememberThis.setFocusPainted(false);
        checkPanel.add(this.rememberThis);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        centerPanel.add((Component)buttonPanel, new GridBagConstraints(0, gridBagIndex++, 1, 1, 1.0, 1.0, 11, 1, new Insets(8, 0, 0, 0), 0, 0));
        RoundedButton cancelButton = new RoundedButton(this.resourceLoader.getString("fixRunData.cancel", new String[0]));
        cancelButton.setFont(this.resourceLoader.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        cancelButton.setContentAreaFilled(false);
        cancelButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        cancelButton.setHoverForeground(UIConstants.COLOR_BLUE);
        cancelButton.addActionListener(e -> {
            this.result = Result.CANCEL;
            this.dispose();
        });
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalGlue());
        RoundedButton okButton = new RoundedButton(this.resourceLoader.getString("fixRunData.OK", new String[0]));
        okButton.setFont(this.resourceLoader.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        okButton.setContentAreaFilled(false);
        okButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        okButton.setHoverForeground(UIConstants.COLOR_BLUE);
        okButton.addActionListener(e -> {
            this.result = Result.ACCEPT;
            this.dispose();
        });
        buttonPanel.add(okButton);
    }

    private Color getPanelColor(boolean isSuccess, boolean hasRecommended) {
        return isSuccess ? UIConstants.COLOR_REQUIREMENT_SUCCEED : (hasRecommended ? UIConstants.COLOR_REQUIREMENT_WARNING : UIConstants.COLOR_REQUIREMENT_FAIL);
    }

    public String getPanelIcon(boolean isSuccess, boolean hasRecommended) {
        return isSuccess ? "req_success.png" : (hasRecommended ? "req_warning.png" : "req_failed.png");
    }

    private Dimension getPreferredSize(String html, int width) {
        resizer.setText(html);
        View view = (View)resizer.getClientProperty("html");
        view.setSize(width, 0.0f);
        float w = view.getPreferredSpan(0);
        float h = view.getPreferredSpan(1);
        return new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
    }

    protected void closeDialog() {
        this.dispose();
    }

    public static enum Result {
        OK,
        ACCEPT,
        CANCEL;

    }
}

