/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.discover;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import net.technicpack.launcher.ui.components.modpacks.ModpackSelector;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.utilslib.DesktopUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.swing.LinkListener;

public class DiscoverLinkListener
extends LinkListener {
    private IPlatformApi platform;
    private ModpackSelector modpackSelector;
    private List<Box> mousedLinks = new LinkedList<Box>();
    private Box _previouslyHovered;

    public DiscoverLinkListener(IPlatformApi platform, ModpackSelector modpackSelector) {
        this.platform = platform;
        this.modpackSelector = modpackSelector;
    }

    @Override
    public void linkClicked(BasicPanel panel, String uri) {
        if (uri.startsWith("platform://")) {
            if (uri.length() < 12) {
                return;
            }
            String slug = uri.substring(11);
            String platformUri = this.platform.getPlatformUri(slug);
            this.modpackSelector.setFilter(platformUri);
        } else {
            DesktopUtils.browseUrl(uri);
        }
    }

    @Override
    public void onMouseOver(BasicPanel panel, Box box) {
        LayoutContext c;
        if (this.isLink(panel, box)) {
            this.mousedLinks.add(box);
            panel.setCursor(Cursor.getPredefinedCursor(12));
        }
        if ((c = panel.getLayoutContext()) == null) {
            return;
        }
        boolean needRepaint = false;
        Element currentlyHovered = this.getHoveredElement(c.getCss(), box);
        if (currentlyHovered == panel.hovered_element) {
            return;
        }
        panel.hovered_element = currentlyHovered;
        Box hoverBox = this.findBoxForElement(currentlyHovered, panel.getRootLayer());
        boolean targetedRepaint = true;
        Rectangle repaintRegion = null;
        if (this._previouslyHovered != null) {
            needRepaint = true;
            this._previouslyHovered.restyle(c);
            PaintingInfo paintInfo = this._previouslyHovered.getPaintingInfo();
            if (paintInfo == null) {
                targetedRepaint = false;
            } else {
                repaintRegion = new Rectangle(paintInfo.getAggregateBounds());
            }
            this._previouslyHovered = null;
        }
        if (currentlyHovered != null) {
            needRepaint = true;
            Box target = hoverBox.getRestyleTarget();
            target.restyle(c);
            if (targetedRepaint) {
                PaintingInfo paintInfo = target.getPaintingInfo();
                if (paintInfo == null) {
                    targetedRepaint = false;
                } else if (repaintRegion == null) {
                    repaintRegion = new Rectangle(paintInfo.getAggregateBounds());
                } else {
                    repaintRegion.add(paintInfo.getAggregateBounds());
                }
            }
            this._previouslyHovered = target;
        }
        if (needRepaint) {
            if (targetedRepaint) {
                panel.repaint(repaintRegion);
            } else {
                panel.repaint();
            }
        }
    }

    private Element getHoveredElement(StyleReference style, Box ib) {
        if (ib == null) {
            return null;
        }
        Element element = ib.getElement();
        while (element != null && !style.isHoverStyled(element)) {
            Node node = element.getParentNode();
            if (node.getNodeType() == 1) {
                element = (Element)node;
                continue;
            }
            element = null;
        }
        return element;
    }

    @Override
    public void onMouseOut(BasicPanel panel, Box box) {
        if (this.mousedLinks.contains(box)) {
            this.mousedLinks.remove(box);
            if (this.mousedLinks.size() == 0) {
                panel.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected boolean isLink(BasicPanel panel, Box box) {
        if (box == null || box.getElement() == null) {
            return false;
        }
        return this.findLink(panel, box.getElement());
    }

    private Box findBoxForElement(Element e, Layer layer) {
        Box find = this.findBoxForElement(e, layer.getMaster());
        if (find != null) {
            return find;
        }
        for (Layer l : layer.getChildren()) {
            find = this.findBoxForElement(e, l);
            if (find == null) continue;
            return find;
        }
        return null;
    }

    private Box findBoxForElement(Element e, Box box) {
        if (box.getElement() == e) {
            return box;
        }
        for (Box b : box.getChildren()) {
            Box find = this.findBoxForElement(e, b);
            if (find == null) continue;
            return find;
        }
        return null;
    }

    private boolean findLink(BasicPanel panel, Element e) {
        Node node = e;
        while (node.getNodeType() == 1) {
            String uri = panel.getSharedContext().getNamespaceHandler().getLinkUri((Element)node);
            if (uri != null) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }
}

