/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.modpacks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.technicpack.discord.IDiscordApi;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.components.modpacks.ModpackBanner;
import net.technicpack.launcher.ui.components.modpacks.ModpackDataDisplay;
import net.technicpack.launcher.ui.controls.feeds.FeedItemView;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.platform.io.FeedItem;
import net.technicpack.ui.controls.RoundedButton;
import net.technicpack.ui.controls.TiledBackground;
import net.technicpack.ui.controls.feeds.HorizontalGallery;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.DesktopUtils;

public class ModpackInfoPanel
extends JPanel
implements IImageJobListener<ModpackModel> {
    private ResourceLoader resources;
    private ImageRepository<ModpackModel> backgroundRepo;
    private ImageRepository<AuthorshipInfo> avatarRepo;
    private ActionListener modpackRefreshListener;
    private TiledBackground tiledBackground;
    private HorizontalGallery feedGallery;
    private ModpackBanner banner;
    private ModpackDataDisplay dataDisplay;
    private RoundedButton playButton;
    private RoundedButton deleteButton;
    private ModpackModel modpack;

    public ModpackInfoPanel(ResourceLoader loader, ImageRepository<ModpackModel> iconRepo, ImageRepository<ModpackModel> logoRepo, ImageRepository<ModpackModel> backgroundRepo, ImageRepository<AuthorshipInfo> avatarRepo, IDiscordApi discordApi, ActionListener modpackOptionsListener, ActionListener modpackRefreshListener) {
        this.resources = loader;
        this.backgroundRepo = backgroundRepo;
        this.avatarRepo = avatarRepo;
        this.modpackRefreshListener = modpackRefreshListener;
        this.initComponents(iconRepo, logoRepo, modpackOptionsListener, discordApi);
    }

    public void setModpackIfSame(ModpackModel modpack) {
        if (modpack == this.modpack) {
            this.setModpack(modpack);
        }
    }

    public void setModpack(ModpackModel modpack) {
        for (ActionListener listener : this.playButton.getActionListeners()) {
            listener.actionPerformed(new ActionEvent(modpack, 0, ""));
        }
        this.modpackRefreshListener.actionPerformed(new ActionEvent(modpack, 0, ""));
        this.modpack = modpack;
        this.banner.setModpack(modpack);
        this.dataDisplay.setModpack(modpack);
        this.deleteButton.setVisible(modpack.getInstalledPack() != null);
        ImageJob<ModpackModel> job = this.backgroundRepo.startImageJob(modpack);
        job.addJobListener(this);
        this.tiledBackground.setImage(job.getImage());
        this.feedGallery.removeAll();
        List<FeedItem> feed = modpack.getFeed();
        if (feed != null) {
            for (FeedItem item : feed) {
                FeedItemView itemView = new FeedItemView(this.resources, item, this.avatarRepo.startImageJob(item.getAuthorship()));
                itemView.addActionListener(e -> this.clickFeedItem((FeedItemView)e.getSource(), e.getActionCommand()));
                this.feedGallery.add(itemView);
            }
        }
        EventQueue.invokeLater(this::repaint);
    }

    public RoundedButton getPlayButton() {
        return this.playButton;
    }

    public RoundedButton getDeleteButton() {
        return this.deleteButton;
    }

    protected void clickLeftFeedButton() {
        this.feedGallery.selectPreviousComponent();
    }

    protected void clickRightFeedButton() {
        this.feedGallery.selectNextComponent();
    }

    protected void clickFeedItem(FeedItemView item, String command) {
        Rectangle r = item.getVisibleRect();
        if (r.getSize().equals(item.getSize())) {
            DesktopUtils.browseUrl(item.getUrl());
        } else {
            this.feedGallery.selectComponent(item);
        }
    }

    private void initComponents(ImageRepository<ModpackModel> iconRepo, ImageRepository<ModpackModel> logoRepo, ActionListener modpackOptionsListener, IDiscordApi discordApi) {
        this.setLayout(new BorderLayout());
        this.tiledBackground = new TiledBackground(null);
        this.tiledBackground.setOpaque(true);
        this.tiledBackground.setLayout(new BorderLayout());
        this.tiledBackground.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.tiledBackground.setBackground(UIConstants.COLOR_CENTRAL_BACK);
        this.tiledBackground.setFilterImage(true);
        this.add((Component)this.tiledBackground, "Center");
        JPanel layoutPanel = new JPanel();
        layoutPanel.setOpaque(false);
        layoutPanel.setLayout(new BoxLayout(layoutPanel, 3));
        layoutPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        this.tiledBackground.add((Component)layoutPanel, "Center");
        this.banner = new ModpackBanner(this.resources, iconRepo, modpackOptionsListener);
        this.banner.setBackground(UIConstants.COLOR_BANNER);
        this.banner.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        layoutPanel.add(this.banner);
        JPanel rootFeedPanel = new JPanel();
        BorderLayout rootFeedLayout = new BorderLayout();
        rootFeedLayout.setVgap(10);
        rootFeedPanel.setLayout(rootFeedLayout);
        rootFeedPanel.setOpaque(false);
        rootFeedPanel.setBorder(BorderFactory.createEmptyBorder(16, 20, 20, 16));
        layoutPanel.add(rootFeedPanel);
        this.dataDisplay = new ModpackDataDisplay(this.resources, logoRepo, discordApi);
        rootFeedPanel.add((Component)this.dataDisplay, "First");
        JPanel feedBottom = new JPanel();
        feedBottom.setOpaque(false);
        feedBottom.setLayout(new GridBagLayout());
        rootFeedPanel.add((Component)feedBottom, "Center");
        JPanel topline = new JPanel();
        topline.setOpaque(false);
        topline.setLayout(new BoxLayout(topline, 2));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.fill = 2;
        feedBottom.add((Component)topline, constraints);
        JLabel toplineLabel = new JLabel(this.resources.getString("launcher.packfeed.title", new String[0]));
        toplineLabel.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 28.0f));
        toplineLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        topline.add(toplineLabel);
        topline.add(Box.createHorizontalGlue());
        JButton leftButton = new JButton(this.resources.getIcon("status_left.png"));
        leftButton.setBorder(BorderFactory.createEmptyBorder());
        leftButton.setContentAreaFilled(false);
        leftButton.addActionListener(e -> this.clickLeftFeedButton());
        topline.add(leftButton);
        JButton rightButton = new JButton(this.resources.getIcon("status_right.png"));
        rightButton.setBorder(BorderFactory.createEmptyBorder());
        rightButton.setContentAreaFilled(false);
        rightButton.addActionListener(e -> this.clickRightFeedButton());
        topline.add(rightButton);
        JLabel label = new JLabel(this.resources.getString("launcher.packfeed.noupdates", new String[0]));
        label.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 20.0f));
        label.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.feedGallery = new HorizontalGallery();
        this.feedGallery.setNoComponentsMessage(label);
        this.feedGallery.setBackground(UIConstants.COLOR_FEED_BACK);
        this.feedGallery.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.ipady = 150;
        constraints.fill = 1;
        feedBottom.add((Component)this.feedGallery, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        Component vertFill = Box.createVerticalStrut(12);
        feedBottom.add(vertFill, constraints);
        this.deleteButton = new RoundedButton(this.resources.getString("modpackoptions.delete.text", new String[0]));
        this.deleteButton.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        this.deleteButton.setBackground(UIConstants.COLOR_FOOTER);
        this.deleteButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.deleteButton.setHoverForeground(UIConstants.COLOR_BLUE);
        this.deleteButton.setAlignmentX(1.0f);
        this.deleteButton.setFocusable(false);
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setShouldShowBackground(true);
        this.deleteButton.setIconTextGap(8);
        this.deleteButton.setHoverIcon(new ImageIcon(this.resources.colorImage(this.resources.getImage("delete_button.png"), UIConstants.COLOR_BLUE)));
        this.deleteButton.setIcon(new ImageIcon(this.resources.colorImage(this.resources.getImage("delete_button.png"), UIConstants.COLOR_BUTTON_BLUE)));
        feedBottom.add((Component)this.deleteButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.weightx = 0.02;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        Component horizFill = Box.createGlue();
        feedBottom.add(horizFill, constraints);
        this.playButton = new RoundedButton(this.resources.getString("launcher.pack.launch", new String[0]));
        this.playButton.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.playButton.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        this.playButton.setBackground(UIConstants.COLOR_FOOTER);
        this.playButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.playButton.setHoverForeground(UIConstants.COLOR_BLUE);
        this.playButton.setAlignmentX(1.0f);
        this.playButton.setFocusable(false);
        this.playButton.setContentAreaFilled(false);
        this.playButton.setShouldShowBackground(true);
        this.playButton.setIconTextGap(8);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        feedBottom.add((Component)this.playButton, constraints);
        feedBottom.add(Box.createVerticalGlue(), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void jobComplete(ImageJob<ModpackModel> job) {
        if (job.getJobData() == this.modpack) {
            this.tiledBackground.setImage(job.getImage());
            EventQueue.invokeLater(this::repaint);
        }
    }
}

