/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.modpacks;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.technicpack.launcher.ui.LauncherFrame;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.components.modpacks.ModpackInfoPanel;
import net.technicpack.launcher.ui.controls.modpacks.FindMoreWidget;
import net.technicpack.launcher.ui.controls.modpacks.ModpackWidget;
import net.technicpack.launchercore.auth.IAuthListener;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.launchercore.modpacks.IModpackContainer;
import net.technicpack.launchercore.modpacks.MemoryModpackContainer;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.PackLoadJob;
import net.technicpack.launchercore.modpacks.PackLoader;
import net.technicpack.launchercore.modpacks.packinfo.CombinedPackInfo;
import net.technicpack.launchercore.modpacks.sources.IPackSource;
import net.technicpack.launchercore.modpacks.sources.NameFilterPackSource;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.platform.IPlatformSearchApi;
import net.technicpack.platform.io.PlatformPackInfo;
import net.technicpack.platform.packsources.SearchResultPackSource;
import net.technicpack.platform.packsources.SinglePlatformSource;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.rest.io.PackInfo;
import net.technicpack.solder.ISolderApi;
import net.technicpack.solder.ISolderPackApi;
import net.technicpack.ui.controls.TintablePanel;
import net.technicpack.ui.controls.WatermarkTextField;
import net.technicpack.ui.controls.borders.RoundBorder;
import net.technicpack.ui.controls.list.SimpleScrollbarUI;
import net.technicpack.ui.lang.IRelocalizableResource;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.DesktopUtils;

public class ModpackSelector
extends TintablePanel
implements IModpackContainer,
IAuthListener,
IRelocalizableResource {
    private static final int MAX_SEARCH_STRING = 90;
    private final transient IPlatformApi platformApi;
    private final transient IPlatformSearchApi platformSearchApi;
    private final transient ISolderApi solderApi;
    private final transient PackLoader packLoader;
    private final transient IPackSource technicSolder;
    private final transient ImageRepository<ModpackModel> iconRepo;
    private final FindMoreWidget findMoreWidget;
    private final transient MemoryModpackContainer defaultPacks = new MemoryModpackContainer();
    private final Map<String, ModpackWidget> allModpacks = new HashMap<String, ModpackWidget>();
    private final Pattern slugRegex;
    private final Pattern siteRegex;
    private transient ResourceLoader resources;
    private JPanel widgetList;
    private ModpackInfoPanel modpackInfoPanel;
    private LauncherFrame launcherFrame;
    private JTextField filterContents;
    private ModpackWidget selectedWidget;
    private transient PackLoadJob currentLoadJob;
    private Timer currentSearchTimer;
    private String lastFilterContents = "";
    private String findMoreUrl;

    public ModpackSelector(ResourceLoader resources, PackLoader packLoader, IPackSource technicSolder, ISolderApi solderApi, IPlatformApi platformApi, IPlatformSearchApi platformSearchApi, ImageRepository<ModpackModel> iconRepo) {
        this.resources = resources;
        this.packLoader = packLoader;
        this.iconRepo = iconRepo;
        this.technicSolder = technicSolder;
        this.platformApi = platformApi;
        this.solderApi = solderApi;
        this.platformSearchApi = platformSearchApi;
        this.slugRegex = Pattern.compile("^[a-zA-Z0-9-]+$");
        this.siteRegex = Pattern.compile("^([a-zA-Z0-9-]+)\\.\\d+$");
        this.findMoreWidget = new FindMoreWidget(resources);
        this.findMoreWidget.addActionListener(e -> DesktopUtils.browseUrl(this.findMoreUrl));
        this.relocalize(resources);
    }

    public void setInfoPanel(ModpackInfoPanel modpackInfoPanel) {
        this.modpackInfoPanel = modpackInfoPanel;
    }

    public void setLauncherFrame(LauncherFrame launcherFrame) {
        this.launcherFrame = launcherFrame;
    }

    public ModpackModel getSelectedPack() {
        if (this.selectedWidget == null) {
            return null;
        }
        return this.selectedWidget.getModpack();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(UIConstants.COLOR_SELECTOR_BACK);
        this.setPreferredSize(new Dimension(304, this.getPreferredSize().height));
        this.setMaximumSize(this.getPreferredSize());
        JPanel header = new JPanel();
        header.setLayout(new GridBagLayout());
        header.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        header.setBackground(UIConstants.COLOR_SELECTOR_OPTION);
        this.add((Component)header, "First");
        this.filterContents = new WatermarkTextField(this.resources.getString("launcher.packselector.filter.hotfix", new String[0]), UIConstants.COLOR_BLUE_DARKER);
        this.filterContents.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.filterContents.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        this.filterContents.setForeground(UIConstants.COLOR_BLUE);
        this.filterContents.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.filterContents.setSelectedTextColor(Color.black);
        this.filterContents.setSelectionColor(UIConstants.COLOR_BUTTON_BLUE);
        this.filterContents.setCaretColor(UIConstants.COLOR_BUTTON_BLUE);
        this.filterContents.setColumns(20);
        ((AbstractDocument)this.filterContents.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                if (fb.getDocument().getLength() + string.length() <= 90) {
                    fb.insertString(offset, string, attr);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                int finalTextLength = fb.getDocument().getLength() - length + text.length();
                if (finalTextLength > 90) {
                    text = text.substring(0, text.length() - (finalTextLength - 90));
                }
                fb.replace(offset, length, text, attrs);
            }
        });
        this.filterContents.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ModpackSelector.this.detectFilterChanges();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ModpackSelector.this.detectFilterChanges();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ModpackSelector.this.detectFilterChanges();
            }
        });
        header.add((Component)this.filterContents, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 0, 3, 0), 0, 12));
        this.widgetList = new JPanel();
        this.widgetList.setOpaque(false);
        this.widgetList.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.widgetList, 20, 31);
        scrollPane.setOpaque(false);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getViewport().setOpaque(false);
        scrollPane.getVerticalScrollBar().setUI(new SimpleScrollbarUI(UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(10, 0));
        scrollPane.getVerticalScrollBar().setUnitIncrement(12);
        this.add((Component)scrollPane, "Center");
        this.widgetList.add(Box.createHorizontalStrut(294), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.widgetList.add(Box.createGlue(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void clear() {
        this.allModpacks.clear();
        this.rebuildUI();
    }

    @Override
    public void addModpackToContainer(ModpackModel modpack) {
        this.setTintActive(true);
        this.addModpackInternal(modpack);
    }

    @Override
    public void replaceModpackInContainer(ModpackModel modpack) {
        if (this.allModpacks.containsKey(modpack.getName())) {
            this.addModpackInternal(modpack);
        }
    }

    @Override
    public void refreshComplete() {
        List<ModpackWidget> sortedPacks;
        this.setTintActive(false);
        if (this.findMoreWidget.getWidgetData().equals(this.resources.getString("launcher.packselector.api", new String[0]))) {
            if (this.allModpacks.isEmpty()) {
                this.findMoreWidget.setWidgetData(this.resources.getString("launcher.packselector.badapi", new String[0]));
                this.findMoreUrl = "https://www.technicpack.net/";
            } else {
                this.findMoreUrl = this.allModpacks.values().iterator().next().getModpack().getWebSite();
            }
        }
        if (!(this.selectedWidget != null && this.selectedWidget.getModpack() != null && this.allModpacks.containsKey(this.selectedWidget.getModpack().getName()) || (sortedPacks = this.sortPacks()).isEmpty())) {
            this.selectWidget(sortedPacks.get(0));
        }
    }

    private List<ModpackWidget> sortPacks() {
        LinkedList<ModpackWidget> sortedPacks = new LinkedList<ModpackWidget>(this.allModpacks.values());
        sortedPacks.sort((o1, o2) -> {
            int priorityCompare = Integer.compare(o2.getModpack().getPriority(), o1.getModpack().getPriority());
            if (priorityCompare != 0) {
                return priorityCompare;
            }
            if (o1.getModpack().getDisplayName() == null && o2.getModpack().getDisplayName() == null) {
                return 0;
            }
            if (o1.getModpack().getDisplayName() == null) {
                return -1;
            }
            if (o2.getModpack().getDisplayName() == null) {
                return 1;
            }
            return o1.getModpack().getDisplayName().compareToIgnoreCase(o2.getModpack().getDisplayName());
        });
        return sortedPacks;
    }

    protected void addModpackInternal(ModpackModel modpack) {
        ModpackWidget widget = new ModpackWidget(this.resources, modpack, this.iconRepo.startImageJob(modpack));
        if (modpack.hasRecommendedUpdate()) {
            widget.setToolTipText(this.resources.getString("launcher.packselector.updatetip", new String[0]));
        }
        widget.addActionListener(e -> {
            if (e.getSource() instanceof ModpackWidget) {
                this.selectWidget((ModpackWidget)e.getSource());
            }
        });
        if (widget.getModpack().isSelected()) {
            this.selectedWidget = widget;
        }
        if (this.allModpacks.containsKey(modpack.getName()) && this.allModpacks.get(modpack.getName()).isSelected()) {
            this.selectedWidget = widget;
        }
        this.allModpacks.put(modpack.getName(), widget);
        this.rebuildUI();
        if (this.selectedWidget != null) {
            EventQueue.invokeLater(() -> {
                if (widget == this.selectedWidget) {
                    this.selectWidget(widget);
                } else {
                    this.selectedWidget.scrollRectToVisible(new Rectangle(this.selectedWidget.getSize()));
                }
            });
        }
    }

    protected void selectWidget(ModpackWidget widget) {
        if (this.selectedWidget != null) {
            this.selectedWidget.setIsSelected(false);
        }
        this.selectedWidget = widget;
        this.selectedWidget.setIsSelected(true);
        this.selectedWidget.getModpack().select();
        this.selectedWidget.scrollRectToVisible(new Rectangle(this.selectedWidget.getSize()));
        if (this.modpackInfoPanel != null) {
            this.modpackInfoPanel.setModpack(widget.getModpack());
        }
        final ModpackWidget refreshWidget = this.selectedWidget;
        Thread thread = new Thread("Modpack redownload " + this.selectedWidget.getModpack().getDisplayName()){

            @Override
            public void run() {
                try {
                    PlatformPackInfo updatedInfo;
                    PackInfo infoToUse = updatedInfo = ModpackSelector.this.platformApi.getPlatformPackInfo(refreshWidget.getModpack().getName());
                    if (updatedInfo != null && updatedInfo.hasSolder()) {
                        try {
                            ISolderPackApi solderPack = ModpackSelector.this.solderApi.getSolderPack(updatedInfo.getSolder(), updatedInfo.getName(), ModpackSelector.this.solderApi.getMirrorUrl(updatedInfo.getSolder()));
                            infoToUse = new CombinedPackInfo(solderPack.getPackInfo(), updatedInfo);
                        }
                        catch (RestfulAPIException restfulAPIException) {
                            // empty catch block
                        }
                    }
                    if (infoToUse != null) {
                        refreshWidget.getModpack().setPackInfo(infoToUse);
                    }
                    EventQueue.invokeLater(() -> {
                        if (ModpackSelector.this.modpackInfoPanel != null) {
                            ModpackSelector.this.modpackInfoPanel.setModpackIfSame(refreshWidget.getModpack());
                        }
                        if (refreshWidget.getModpack().hasRecommendedUpdate()) {
                            refreshWidget.setToolTipText(ModpackSelector.this.resources.getString("launcher.packselector.updatetip", new String[0]));
                        } else {
                            refreshWidget.setToolTipText(null);
                        }
                        ModpackSelector.this.iconRepo.refreshRetry(refreshWidget.getModpack());
                        refreshWidget.updateFromPack(ModpackSelector.this.iconRepo.startImageJob(refreshWidget.getModpack()));
                        EventQueue.invokeLater(() -> {
                            ModpackSelector.this.revalidate();
                            ModpackSelector.this.repaint();
                        });
                    });
                }
                catch (RestfulAPIException ex) {
                    ex.printStackTrace();
                }
            }
        };
        thread.start();
    }

    protected void rebuildUI() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this::rebuildUI);
            return;
        }
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.widgetList.removeAll();
        List<ModpackWidget> sortedPacks = this.sortPacks();
        for (ModpackWidget sortedPack : sortedPacks) {
            this.widgetList.add((Component)sortedPack, constraints);
            ++constraints.gridy;
        }
        if (this.filterContents.getText().length() >= 3) {
            this.widgetList.add((Component)this.findMoreWidget, constraints);
        }
        this.widgetList.add(Box.createHorizontalStrut(294), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.widgetList.add(Box.createGlue(), constraints);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void userChanged(IUserType user) {
        if (!this.filterContents.getText().isEmpty()) {
            this.filterContents.setText("");
        } else {
            this.detectFilterChanges();
        }
        if (user != null) {
            ArrayList<IPackSource> sources = new ArrayList<IPackSource>(1);
            sources.add(this.technicSolder);
            this.defaultPacks.addPassthroughContainer(this);
            this.packLoader.createRepositoryLoadJob(this.defaultPacks, sources, null, true);
        }
    }

    public void forceRefresh() {
        this.lastFilterContents = "THIS IS A TERRIBLE HACK I'M BASICALLY FORCING A REFRESH BUT WITHOUT DOING ANY WORK";
        this.defaultPacks.clear();
        this.detectFilterChanges();
        ArrayList<IPackSource> sources = new ArrayList<IPackSource>(1);
        sources.add(this.technicSolder);
        this.packLoader.createRepositoryLoadJob(this.defaultPacks, sources, null, true);
    }

    public void setFilter(String text) {
        this.filterContents.setText(text);
        this.detectFilterChanges();
        if (this.launcherFrame != null) {
            this.launcherFrame.selectTab("modpacks");
        }
    }

    protected void detectFilterChanges() {
        this.cancelJob();
        if (this.filterContents.getText().length() >= 3) {
            this.loadNewJob(this.filterContents.getText());
        } else if (this.lastFilterContents.length() >= 3) {
            this.clear();
            this.defaultPacks.addPassthroughContainer(this);
            for (ModpackModel modpack : this.defaultPacks.getModpacks()) {
                this.addModpackToContainer(modpack);
            }
            this.refreshComplete();
        }
        this.lastFilterContents = this.filterContents.getText();
    }

    private void loadNewJob(String searchText) {
        this.setTintActive(true);
        this.defaultPacks.removePassthroughContainer(this);
        this.currentSearchTimer = new Timer(500, e -> {
            String localSearchTag = searchText.trim();
            String localSearchUrl = searchText.trim();
            if (!localSearchUrl.startsWith("http://") && !localSearchUrl.startsWith("https://")) {
                localSearchUrl = "https://" + localSearchTag;
            }
            try {
                URI uri = new URI(localSearchUrl);
                String host = uri.getHost();
                String scheme = uri.getScheme();
                if (host != null && scheme != null && (scheme.equals("http") || scheme.equals("https")) && (host.equals("www.technicpack.net") || host.equals("technicpack.net") || host.equals("api.technicpack.net"))) {
                    String[] fragments;
                    String path = uri.getPath();
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if ((fragments = path.split("/")).length == 2 && fragments[0].equals("modpack") || fragments.length == 3 && fragments[0].equals("api") && fragments[1].equals("modpack")) {
                        Matcher slugMatcher;
                        String slug = fragments[fragments.length - 1];
                        Matcher siteMatcher = this.siteRegex.matcher(slug);
                        if (siteMatcher.find()) {
                            slug = siteMatcher.group(1);
                        }
                        if ((slugMatcher = this.slugRegex.matcher(slug)).find()) {
                            this.findMoreUrl = localSearchUrl;
                            this.findMoreWidget.setWidgetData(this.resources.getString("launcher.packselector.api", new String[0]));
                            ArrayList<IPackSource> source = new ArrayList<IPackSource>(1);
                            source.add(new SinglePlatformSource(this.platformApi, this.solderApi, slug));
                            this.currentLoadJob = this.packLoader.createRepositoryLoadJob(this, source, null, false);
                            return;
                        }
                    }
                }
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
            String encodedSearch = this.filterContents.getText();
            try {
                encodedSearch = URLEncoder.encode(encodedSearch, "UTF-8");
            }
            catch (UnsupportedEncodingException host) {
                // empty catch block
            }
            this.findMoreUrl = "https://www.technicpack.net/modpacks?q=" + encodedSearch;
            this.findMoreWidget.setWidgetData(this.resources.getString("launcher.packselector.more", new String[0]));
            ArrayList<IPackSource> sources = new ArrayList<IPackSource>(2);
            sources.add(new NameFilterPackSource(this.defaultPacks, localSearchTag));
            sources.add(new SearchResultPackSource(this.platformSearchApi, localSearchTag));
            this.currentLoadJob = this.packLoader.createRepositoryLoadJob(this, sources, null, false);
        });
        this.currentSearchTimer.setRepeats(false);
        this.currentSearchTimer.start();
    }

    private void cancelJob() {
        if (this.currentLoadJob != null) {
            this.currentLoadJob.cancel();
        }
        if (this.currentSearchTimer != null) {
            this.currentSearchTimer.stop();
        }
    }

    @Override
    public void relocalize(ResourceLoader loader) {
        this.resources = loader;
        this.resources.registerResource(this);
        this.setOverIcon(this.resources.getIcon("loader.gif"));
        this.setTintActive(true);
        this.removeAll();
        this.setLayout(null);
        this.initComponents();
        EventQueue.invokeLater(() -> {
            this.invalidate();
            this.repaint();
        });
    }
}

