/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.news;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.components.news.AuthorshipWidget;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.platform.io.NewsArticle;
import net.technicpack.ui.controls.RoundedButton;
import net.technicpack.ui.controls.list.SimpleScrollbarUI;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.DesktopUtils;

public class NewsInfoPanel
extends JPanel
implements PropertyChangeListener {
    private ResourceLoader resources;
    private ImageRepository<AuthorshipInfo> avatarRepo;
    JTextPane newsText;
    JScrollPane newsScroller;
    AuthorshipWidget authorshipInfo;
    JLabel title;
    private String url = "";

    public NewsInfoPanel(ResourceLoader resources, ImageRepository<AuthorshipInfo> avatarRepo) {
        this.resources = resources;
        this.avatarRepo = avatarRepo;
        this.initComponents();
    }

    public void setArticle(NewsArticle article) {
        if (article == null) {
            this.newsText.setText("");
            this.url = "";
            return;
        }
        this.title.setText(article.getTitle());
        this.url = article.getUrl();
        this.newsText.setText("<html><head><style type=\"text/css\">a{color:#309aeb}body{font-family:\"" + this.newsText.getFont().getFamily() + "\";color:#D0D0D0}</style></head><body>" + article.getContent() + "</body></html>");
        this.authorshipInfo.setAuthorshipInfo(article.getAuthorshipInfo(), this.avatarRepo.startImageJob(article.getAuthorshipInfo()));
        EventQueue.invokeLater(() -> this.newsText.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
    }

    protected void visitCurrentItem() {
        if (this.url != null && !this.url.isEmpty()) {
            DesktopUtils.browseUrl(this.url);
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 18, 16));
        this.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        this.title = new JLabel("");
        this.title.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.title.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 26.0f));
        this.title.setCursor(Cursor.getPredefinedCursor(12));
        this.title.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewsInfoPanel.this.visitCurrentItem();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.add((Component)this.title, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.authorshipInfo = new AuthorshipWidget(this.resources);
        this.add((Component)this.authorshipInfo, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
        this.newsText = new JTextPane();
        this.newsText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.newsText.setOpaque(false);
        this.newsText.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.newsText.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.newsText.setEditable(false);
        this.newsText.setHighlighter(null);
        this.newsText.setAlignmentX(0.0f);
        this.newsText.setContentType("text/html");
        this.newsText.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
                DesktopUtils.browseUrl(e.getURL().toString());
            }
        });
        this.newsText.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                NewsInfoPanel.this.revalidate();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.newsScroller = new JScrollPane(this.newsText, 20, 31);
        this.newsScroller.getVerticalScrollBar().setUI(new SimpleScrollbarUI(UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.newsScroller.getVerticalScrollBar().setPreferredSize(new Dimension(10, 10));
        this.newsScroller.setBorder(BorderFactory.createEmptyBorder());
        this.newsScroller.setMaximumSize(new Dimension(32000, 900));
        this.newsScroller.setOpaque(false);
        this.newsScroller.getViewport().setOpaque(false);
        JPanel newsTextPanel = new JPanel();
        newsTextPanel.setLayout(new BoxLayout(newsTextPanel, 3));
        newsTextPanel.setOpaque(false);
        newsTextPanel.add(this.newsScroller);
        newsTextPanel.add(Box.createVerticalGlue());
        this.add((Component)newsTextPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        RoundedButton discussButton = new RoundedButton(this.resources.getString("launcher.news.discuss", new String[0]));
        discussButton.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        discussButton.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        discussButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        discussButton.setHoverForeground(UIConstants.COLOR_BLUE);
        discussButton.setAlignmentX(1.0f);
        discussButton.setContentAreaFilled(false);
        discussButton.addActionListener(e -> this.visitCurrentItem());
        this.add((Component)discussButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 14, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.invalidate();
    }
}

