/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.controls.feeds;

import java.awt.Dimension;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.controls.SelectorWidget;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.platform.io.NewsArticle;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.ImageUtils;

public class NewsWidget
extends SelectorWidget
implements IImageJobListener<AuthorshipInfo> {
    private NewsArticle article;
    private ImageJob<AuthorshipInfo> avatar;
    private JLabel avatarView;

    public NewsWidget(ResourceLoader resources, NewsArticle article, ImageJob<AuthorshipInfo> avatar) {
        super(resources);
        this.article = article;
        this.avatar = avatar;
        avatar.addJobListener(this);
        this.initComponents();
        this.setAvatar(avatar);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 15));
        this.avatarView = new JLabel();
        this.add(this.avatarView);
        this.add(Box.createHorizontalStrut(10));
        JLabel text = new JLabel(this.article.getTitle());
        text.setFont(this.getResources().getFont("OpenSans+Cyberbit.ttf", 14.0f));
        text.setForeground(UIConstants.COLOR_WHITE_TEXT);
        text.setPreferredSize(new Dimension(200, text.getPreferredSize().height));
        this.add(text);
        this.add(Box.createHorizontalGlue());
        this.add(Box.createHorizontalStrut(5));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.article.getDate());
        DateFormat format = DateFormat.getDateInstance(3);
        JLabel date = new JLabel(format.format(this.article.getDate()));
        date.setFont(this.getResources().getFont("OpenSans+Cyberbit.ttf", 12.0f));
        date.setForeground(UIConstants.COLOR_DIM_TEXT);
        this.add(date);
    }

    public NewsArticle getArticle() {
        return this.article;
    }

    @Override
    public void jobComplete(ImageJob<AuthorshipInfo> job) {
        this.setAvatar(job);
    }

    private void setAvatar(ImageJob<AuthorshipInfo> job) {
        this.avatarView.setIcon(new ImageIcon(this.getResources().getCircleClippedImage(ImageUtils.scaleWithAspectWidth(job.getImage(), 32))));
    }
}

