/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.controls.modpacks;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;

public class ModpackTag
extends JLabel {
    private static final int HORIZONTAL_PADDING = 8;
    private static final int VERTICAL_PADDING = 4;

    public ModpackTag(String text) {
        super(text);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int textSize = this.getFontMetrics(this.getFont()).getHeight();
        int textWidth = this.getFontMetrics(this.getFont()).stringWidth(this.getText());
        return new Dimension(textWidth + 8, textSize + 4);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setColor(this.getBackground());
        g2d.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 5, 5);
        g2d.setColor(this.getForeground());
        g2d.setFont(this.getFont());
        int textY = 1 + (this.getHeight() - 2 - g2d.getFontMetrics().getHeight()) / 2 + g2d.getFontMetrics().getAscent();
        g2d.drawString(this.getText(), 4, textY);
        g2d.dispose();
    }
}

