/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.controls.modpacks;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.border.LineBorder;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.controls.SelectorWidget;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.ImageUtils;

public class ModpackWidget
extends SelectorWidget
implements IImageJobListener<ModpackModel> {
    private ModpackModel modpack;
    private ImageJob<ModpackModel> imageJob;
    private ResourceLoader resources;
    private JLabel icon;
    private JLabel displayName;
    private JLabel updateIcon;

    public ModpackWidget(ResourceLoader resources, ModpackModel modpack, ImageJob<ModpackModel> job) {
        super(resources);
        this.resources = resources;
        this.imageJob = job;
        this.imageJob.addJobListener(this);
        this.modpack = modpack;
        this.initComponents();
    }

    public ModpackModel getModpack() {
        return this.modpack;
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.setBorder(BorderFactory.createEmptyBorder(4, 16, 4, 8));
        this.setLayout(new GridBagLayout());
        this.icon = new JLabel();
        this.icon.setIcon(new ImageIcon(ImageUtils.scaleWithAspectWidth(this.imageJob.getImage(), 32)));
        this.add((Component)this.icon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 14), 0, 0));
        this.displayName = new JLabel(this.modpack.getDisplayName());
        this.displayName.setFont(this.getResources().getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.displayName.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.displayName.setPreferredSize(new Dimension(210, this.displayName.getPreferredSize().height));
        this.displayName.setHorizontalAlignment(2);
        this.add((Component)this.displayName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.updateIcon = new JLabel();
        this.updateIcon.setIcon(this.getResources().getIcon("update_available.png"));
        this.add((Component)this.updateIcon, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.updateIcon.setVisible(this.modpack.hasRecommendedUpdate());
    }

    public void updateFromPack(ImageJob<ModpackModel> job) {
        this.displayName.setText(this.modpack.getDisplayName());
        this.updateIcon.setVisible(this.modpack.hasRecommendedUpdate());
        this.icon.setIcon(new ImageIcon(ImageUtils.scaleWithAspectWidth(job.getImage(), 32)));
        job.addJobListener(this);
    }

    @Override
    public void jobComplete(ImageJob<ModpackModel> job) {
        this.icon.setIcon(new ImageIcon(ImageUtils.scaleWithAspectWidth(job.getImage(), 32)));
        this.revalidate();
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip toolTip = new JToolTip();
        toolTip.setBackground(UIConstants.COLOR_FOOTER);
        toolTip.setForeground(UIConstants.COLOR_GREY_TEXT);
        toolTip.setBorder(BorderFactory.createCompoundBorder(new LineBorder(UIConstants.COLOR_GREY_TEXT), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        toolTip.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        return toolTip;
    }
}

