/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.listitems;

import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.ui.lang.ResourceLoader;

public class PackBuildItem {
    private boolean isRecommended;
    private boolean isLatest;
    private String buildNumber;
    private String display;

    public PackBuildItem(String buildNumber, ResourceLoader loader, ModpackModel model) {
        this.buildNumber = buildNumber;
        this.isRecommended = buildNumber.equals(model.getRecommendedBuild());
        this.isLatest = buildNumber.equals(model.getLatestBuild());
        this.display = buildNumber;
        if (this.isRecommended) {
            this.display = this.display + " - " + loader.getString("modpackoptions.build.recommended", new String[0]);
        } else if (this.isLatest) {
            this.display = this.display + " - " + loader.getString("modpackoptions.build.latest", new String[0]);
        }
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isRecommended() {
        return this.isRecommended;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PackBuildItem item = (PackBuildItem)obj;
        return item.getBuildNumber().equals(this.buildNumber);
    }

    public int hashCode() {
        return this.getBuildNumber().hashCode();
    }

    public String toString() {
        return this.display;
    }
}

