/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersionComparator
implements Comparator<String> {
    private static final Pattern LEGACY_PATTERN = Pattern.compile("^1\\.(\\d+)\\.0_(\\d+)(?:[-+].*)?$");
    private static final Pattern NEW_PATTERN = Pattern.compile("^(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?(?:[-+].*)?$");

    @Override
    public int compare(String v1, String v2) {
        int[] arr1 = this.parseVersion(v1);
        int[] arr2 = this.parseVersion(v2);
        int len1 = arr1.length;
        int len2 = arr2.length;
        int len = Math.max(len1, len2);
        for (int i = 0; i < len; ++i) {
            int b;
            int a = i < len1 ? arr1[i] : 0;
            int n = b = i < len2 ? arr2[i] : 0;
            if (a == b) continue;
            return a - b;
        }
        return 0;
    }

    private int[] parseVersion(String version) {
        Matcher legacy = LEGACY_PATTERN.matcher(version);
        if (legacy.matches()) {
            int major = Integer.parseInt(legacy.group(1));
            int update = Integer.parseInt(legacy.group(2));
            return new int[]{major, 0, update};
        }
        Matcher modern = NEW_PATTERN.matcher(version);
        if (modern.matches()) {
            int[] parts = new int[4];
            for (int i = 1; i <= 4; ++i) {
                String group = modern.group(i);
                parts[i - 1] = group != null ? Integer.parseInt(group) : 0;
            }
            return parts;
        }
        throw new IllegalArgumentException("Invalid Java version string: " + version);
    }
}

