/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.auth;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import net.technicpack.launchercore.auth.IAuthListener;
import net.technicpack.launchercore.auth.IUserStore;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.exception.AuthenticationException;
import net.technicpack.launchercore.exception.ResponseException;
import net.technicpack.launchercore.exception.SessionException;
import net.technicpack.minecraftcore.microsoft.auth.MicrosoftAuthenticator;
import net.technicpack.minecraftcore.microsoft.auth.MicrosoftUser;
import net.technicpack.utilslib.Utils;

public class UserModel {
    private IUserType mCurrentUser = null;
    private List<IAuthListener> mAuthListeners = new LinkedList<IAuthListener>();
    private IUserStore mUserStore;
    private MicrosoftAuthenticator microsoftAuthenticator;

    public UserModel(IUserStore userStore, MicrosoftAuthenticator microsoftAuthenticator) {
        this.mUserStore = userStore;
        this.microsoftAuthenticator = microsoftAuthenticator;
    }

    public IUserType getCurrentUser() {
        return this.mCurrentUser;
    }

    public void setCurrentUser(IUserType user) {
        this.mCurrentUser = user;
        if (user != null) {
            this.setLastUser(user);
        }
        this.triggerAuthListeners();
    }

    public void addAuthListener(IAuthListener listener) {
        this.mAuthListeners.add(listener);
    }

    protected void triggerAuthListeners() {
        for (IAuthListener listener : this.mAuthListeners) {
            listener.userChanged(this.mCurrentUser);
        }
    }

    public void startupAuth() {
        IUserType user = this.getLastUser();
        if (user == null) {
            this.setCurrentUser(null);
            return;
        }
        try {
            user.login(this);
            this.addUser(user);
            this.setCurrentUser(user);
        }
        catch (ResponseException | SessionException ex) {
            this.setCurrentUser(null);
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Login Error", 0);
        }
        catch (AuthenticationException ex) {
            Utils.getLogger().log(Level.SEVERE, "Authentication error, running in offline mode", ex);
            JOptionPane.showMessageDialog(null, "Due to an authentication error, you're playing in offline mode.\n\nUntil you are properly logged in you won't be able to connect to multiplayer servers.", "Offline mode", 2);
            this.setCurrentUser(new MicrosoftUser(user.getId(), user.getUsername()));
        }
    }

    public Collection<IUserType> getUsers() {
        return this.mUserStore.getSavedUsers();
    }

    public IUserType getLastUser() {
        return this.mUserStore.getUser(this.mUserStore.getLastUser());
    }

    public void addUser(IUserType user) {
        this.mUserStore.addUser(user);
    }

    public void removeUser(IUserType user) {
        this.mUserStore.removeUser(user.getUsername());
    }

    public void setLastUser(IUserType user) {
        this.mUserStore.setLastUser(user.getUsername());
    }

    public MicrosoftAuthenticator getMicrosoftAuthenticator() {
        return this.microsoftAuthenticator;
    }
}

