/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.image;

import java.util.HashMap;
import java.util.Map;
import net.technicpack.launchercore.image.IImageMapper;
import net.technicpack.launchercore.image.IImageStore;
import net.technicpack.launchercore.image.ImageJob;

public class ImageRepository<T> {
    private IImageMapper<T> mapper;
    private IImageStore<T> store;
    private Map<String, ImageJob<T>> allJobs = new HashMap<String, ImageJob<T>>();

    public ImageRepository(IImageMapper<T> mapper, IImageStore<T> store) {
        this.mapper = mapper;
        this.store = store;
    }

    public ImageJob<T> startImageJob(T key) {
        ImageJob<T> job;
        String jobKey = this.store.getJobKey(key);
        if (this.allJobs.containsKey(jobKey)) {
            job = this.allJobs.get(jobKey);
        } else {
            job = new ImageJob<T>(this.mapper, this.store);
            this.allJobs.put(jobKey, job);
        }
        if (job.canRetry()) {
            job.start(key);
        }
        return job;
    }

    public void refreshRetry(T key) {
        String jobKey = this.store.getJobKey(key);
        if (this.allJobs.containsKey(jobKey)) {
            this.allJobs.get(jobKey).refreshRetry();
        }
    }
}

