/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.image.face;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.image.IImageStore;
import net.technicpack.utilslib.Utils;

public class CrafatarFaceImageStore
implements IImageStore<IUserType> {
    private String mBaseUrl;

    public CrafatarFaceImageStore(String baseUrl) {
        this.mBaseUrl = baseUrl;
    }

    @Override
    public boolean canDownloadImage(IUserType user, File location) {
        return true;
    }

    @Override
    public void downloadImage(IUserType user, File location) {
        try {
            Utils.downloadFile(this.mBaseUrl + "avatars/" + user.getId() + "?size=100&overlay", user.getDisplayName(), location.getAbsolutePath());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.INFO, "Error downloading user face image: " + user.getDisplayName(), e);
        }
    }

    @Override
    public String getJobKey(IUserType key) {
        return "user-face-" + key.getDisplayName();
    }

    @Override
    public boolean canRetry(IUserType key) {
        return false;
    }
}

