/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.image.face;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import net.technicpack.launchercore.image.IImageStore;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.utilslib.Utils;

public class WebAvatarImageStore
implements IImageStore<AuthorshipInfo> {
    @Override
    public boolean canDownloadImage(AuthorshipInfo key, File target) {
        return true;
    }

    @Override
    public void downloadImage(AuthorshipInfo key, File target) {
        try {
            Utils.downloadFile(key.getAvatar(), key.getUser(), target.getAbsolutePath());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.INFO, "Error downloading user avatar: " + key.getUser(), e);
        }
    }

    @Override
    public String getJobKey(AuthorshipInfo key) {
        return "user-avatar-" + key.getUser();
    }

    @Override
    public boolean canRetry(AuthorshipInfo key) {
        return false;
    }
}

