/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install;

import io.sentry.Sentry;
import java.io.IOException;
import java.util.LinkedList;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.util.DownloadListener;

public class InstallTasksQueue<T>
implements ITasksQueue<T> {
    private final DownloadListener listener;
    private final LinkedList<IInstallTask<T>> tasks;
    private IInstallTask<T> currentTask;
    private T metadata;

    public InstallTasksQueue(DownloadListener listener) {
        this.listener = listener;
        this.tasks = new LinkedList();
        this.currentTask = null;
    }

    public void refreshProgress() {
        if (this.listener != null) {
            this.listener.stateChanged(this.currentTask.getTaskDescription(), this.currentTask.getTaskProgress());
        }
    }

    public void runAllTasks() throws IOException, InterruptedException {
        while (!this.tasks.isEmpty()) {
            this.currentTask = this.tasks.removeFirst();
            Sentry.addBreadcrumb(String.format("Running task: \"%s\" (%s)", this.currentTask.getTaskDescription(), this.currentTask.getClass().getSimpleName()));
            this.refreshProgress();
            this.currentTask.runTask(this);
        }
    }

    @Override
    public void addNextTask(IInstallTask<T> task) {
        this.tasks.addFirst(task);
    }

    @Override
    public void addTask(IInstallTask<T> task) {
        this.tasks.addLast(task);
    }

    public DownloadListener getDownloadListener() {
        return this.listener;
    }

    public void setMetadata(T metadata) {
        this.metadata = metadata;
    }

    public T getMetadata() {
        return this.metadata;
    }
}

