/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;

public class ModpackVersion {
    private String version;
    private boolean legacy;

    private ModpackVersion() {
    }

    public ModpackVersion(String version, boolean legacy) {
        this.version = version;
        this.legacy = legacy;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public String getVersion() {
        return this.version;
    }

    public static ModpackVersion load(File versionFile) {
        if (!versionFile.exists()) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to load version from %s because it does not exist.", versionFile));
            return null;
        }
        try {
            String json = FileUtils.readFileToString(versionFile, StandardCharsets.UTF_8);
            return Utils.getGson().fromJson(json, ModpackVersion.class);
        }
        catch (JsonSyntaxException | IOException e) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to load version from %s", versionFile), e);
            return null;
        }
    }

    public void save(File versionFile) {
        String json = Utils.getGson().toJson(this);
        try {
            FileUtils.writeStringToFile(versionFile, json, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to save installed %s", versionFile), e);
        }
    }

    public String toString() {
        return String.format("ModpackVersion{version='%s', legacy=%s}", this.version, this.legacy);
    }
}

