/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.IWeightedTasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;

public class ParallelTaskGroup<T>
implements IInstallTask<T>,
IWeightedTasksQueue<T> {
    private final String groupName;
    private final Map<IInstallTask<T>, Float> taskWeights = new LinkedHashMap<IInstallTask<T>, Float>();
    private final List<IInstallTask<T>> taskList = new ArrayList<IInstallTask<T>>();
    private float totalWeight = 0.0f;
    private final AtomicInteger completedTasks = new AtomicInteger(0);
    private final AtomicReference<String> currentFile = new AtomicReference<String>("");
    private final ExecutorService executor;
    private final Object taskListLock = new Object();

    public ParallelTaskGroup(String name) {
        this.groupName = name;
        this.executor = ParallelTaskGroup.createDefaultExecutor();
    }

    private static ExecutorService createDefaultExecutor() {
        int maxThreads = Math.min(64, Runtime.getRuntime().availableProcessors());
        return Executors.newFixedThreadPool(maxThreads, r -> {
            Thread t = new Thread(r);
            t.setName(String.format("ParallelTaskGroup-%d", t.getId()));
            t.setDaemon(true);
            return t;
        });
    }

    @Override
    public void runTask(InstallTasksQueue<T> queue) throws IOException, InterruptedException {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (IInstallTask<T> task : this.taskList) {
            futures.add(CompletableFuture.runAsync(() -> {
                try {
                    this.currentFile.set(task.getTaskDescription());
                    task.runTask(queue);
                    this.completedTasks.incrementAndGet();
                    queue.refreshProgress();
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CompletionException(e);
                }
            }, this.executor));
        }
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new DownloadException(cause);
        }
        finally {
            this.executor.shutdown();
        }
    }

    @Override
    public String getTaskDescription() {
        return this.groupName.replace("%s", this.currentFile.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getTaskProgress() {
        Object object = this.taskListLock;
        synchronized (object) {
            if (this.taskList.isEmpty() || this.totalWeight == 0.0f) {
                return 0.0f;
            }
            float completedWeight = 0.0f;
            for (IInstallTask<T> task : this.taskList) {
                float weight = this.taskWeights.getOrDefault(task, Float.valueOf(1.0f)).floatValue();
                completedWeight += task.getTaskProgress() / 100.0f * weight;
            }
            return completedWeight / this.totalWeight * 100.0f;
        }
    }

    @Override
    public void addTask(IInstallTask<T> task) {
        this.addTask(task, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(IInstallTask<T> task, float weight) {
        Object object = this.taskListLock;
        synchronized (object) {
            this.taskList.add(task);
            this.taskWeights.put(task, Float.valueOf(weight));
            this.totalWeight += weight;
        }
    }

    @Override
    public void addNextTask(IInstallTask<T> task) {
        this.addNextTask(task, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNextTask(IInstallTask<T> task, float weight) {
        Object object = this.taskListLock;
        synchronized (object) {
            this.taskList.add(0, task);
            this.taskWeights.put(task, Float.valueOf(weight));
            this.totalWeight += weight;
        }
    }
}

