/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.tasks;

import io.sentry.Sentry;
import java.io.IOException;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import net.technicpack.launchercore.install.IWeightedTasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;

public class TaskGroup<T>
implements IWeightedTasksQueue<T>,
IInstallTask<T> {
    private final String groupName;
    private final LinkedList<IInstallTask<T>> taskList = new LinkedList();
    private final Map<IInstallTask<T>, Float> taskWeights = new HashMap<IInstallTask<T>, Float>();
    private final Object taskListLock = new Object();
    private float totalWeight = 0.0f;
    private float completedWeight = 0.0f;
    private IInstallTask<T> currentTask;
    private String currentTaskDescription = "";

    public TaskGroup(String name) {
        this.groupName = name;
    }

    @Override
    public String getTaskDescription() {
        try {
            return String.format(Locale.ENGLISH, this.groupName, this.currentTaskDescription);
        }
        catch (IllegalFormatException e) {
            return this.groupName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getTaskProgress() {
        Object object = this.taskListLock;
        synchronized (object) {
            if (this.totalWeight == 0.0f) {
                return 0.0f;
            }
            float progress = this.completedWeight;
            if (this.currentTask != null) {
                float currentTaskWeight = this.taskWeights.getOrDefault(this.currentTask, Float.valueOf(1.0f)).floatValue();
                progress += this.currentTask.getTaskProgress() / 100.0f * currentTaskWeight;
            }
            return progress / this.totalWeight * 100.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTask(InstallTasksQueue<T> queue) throws IOException, InterruptedException {
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Object object = this.taskListLock;
            synchronized (object) {
                if (this.taskList.isEmpty()) {
                    break;
                }
                this.currentTask = this.taskList.removeFirst();
                this.currentTaskDescription = this.currentTask.getTaskDescription();
            }
            Sentry.addBreadcrumb(String.format("TaskGroup \"%s\" running task \"%s\"", this.groupName, this.currentTaskDescription));
            this.currentTask.runTask(queue);
            Sentry.addBreadcrumb(String.format("TaskGroup \"%s\" finished task \"%s\"", this.groupName, this.currentTaskDescription));
            object = this.taskListLock;
            synchronized (object) {
                queue.refreshProgress();
                this.completedWeight += this.taskWeights.getOrDefault(this.currentTask, Float.valueOf(1.0f)).floatValue();
                this.taskWeights.remove(this.currentTask);
            }
        }
    }

    @Override
    public void addNextTask(IInstallTask<T> task) {
        this.addNextTask(task, 1.0f);
    }

    @Override
    public void addTask(IInstallTask<T> task) {
        this.addTask(task, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(IInstallTask<T> task, float weight) {
        Object object = this.taskListLock;
        synchronized (object) {
            this.taskList.addLast(task);
            this.taskWeights.put(task, Float.valueOf(weight));
            this.totalWeight += weight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNextTask(IInstallTask<T> task, float weight) {
        Object object = this.taskListLock;
        synchronized (object) {
            this.taskList.addFirst(task);
            this.taskWeights.put(task, Float.valueOf(weight));
            this.totalWeight += weight;
        }
    }
}

