/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.ListenerTask;
import net.technicpack.utilslib.IZipFileFilter;
import net.technicpack.utilslib.ZipUtils;

public class UnzipFileTask<T>
extends ListenerTask<T> {
    private File zipFile;
    private File destination;
    private IZipFileFilter filter;

    public UnzipFileTask(File zipFile, File destination, IZipFileFilter filter) {
        this.zipFile = zipFile;
        this.destination = destination;
        this.filter = filter;
    }

    @Override
    public String getTaskDescription() {
        return "Unzipping " + this.zipFile.getName();
    }

    @Override
    public void runTask(InstallTasksQueue<T> queue) throws IOException, InterruptedException {
        super.runTask(queue);
        if (!this.zipFile.exists()) {
            throw new ZipException("Attempting to extract file " + this.zipFile.getName() + ", but it did not exist.");
        }
        if (!this.destination.exists()) {
            this.destination.mkdirs();
        }
        try {
            ZipUtils.unzipFile(this.zipFile, this.destination, this.filter, this);
        }
        catch (ZipException ex) {
            ex.printStackTrace();
            throw new ZipException("Error extracting file " + this.zipFile.getName() + ".");
        }
    }
}

