/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.verifiers;

import java.io.File;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.CryptoUtils;
import net.technicpack.utilslib.Utils;

public class SHA1FileVerifier
implements IFileVerifier {
    private String sha1Hash;

    public SHA1FileVerifier(String sha1Hash) {
        this.sha1Hash = sha1Hash;
    }

    @Override
    public boolean isFileValid(File file) {
        if (this.sha1Hash == null || this.sha1Hash.isEmpty()) {
            return false;
        }
        String resultSha1 = CryptoUtils.getSHA1(file);
        boolean hashMatches = this.sha1Hash.equalsIgnoreCase(resultSha1);
        if (!hashMatches) {
            Utils.getLogger().warning("SHA1 verification for " + file + " failed. Expected " + this.sha1Hash + ", got " + resultSha1);
        }
        return hashMatches;
    }
}

