/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.launch.java.source.os;

import java.io.File;
import net.technicpack.launchercore.launch.java.IVersionSource;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.launch.java.version.FileBasedJavaRuntime;
import net.technicpack.utilslib.Utils;

public class MacInstalledJavaSource
implements IVersionSource {
    @Override
    public void enumerateVersions(JavaVersionRepository repository) {
        repository.addVersion(new FileBasedJavaRuntime(new File(this.getMacJava("1.6"))));
        repository.addVersion(new FileBasedJavaRuntime(new File(this.getMacJava("1.7"))));
        repository.addVersion(new FileBasedJavaRuntime(new File(this.getMacJava("1.8"))));
        repository.addVersion(new FileBasedJavaRuntime(new File("/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java")));
        this.enumerateJavaHome(repository);
    }

    protected String getMacJava(String versionNumber) {
        String path = Utils.getProcessOutput("/usr/libexec/java_home", "-v", versionNumber);
        return path + File.separator + "bin" + File.separator + "java";
    }

    private void enumerateJavaHome(JavaVersionRepository repository) {
        String output = Utils.getProcessOutput("/usr/libexec/java_home", "-V");
        if (output == null || output.isEmpty()) {
            return;
        }
        for (String line : output.split("\\r?\\n")) {
            int pathIndex = line.indexOf("/Library/");
            if (pathIndex < 0) continue;
            String path = line.substring(pathIndex).trim();
            repository.addVersion(new FileBasedJavaRuntime(new File(path + File.separator + "bin" + File.separator + "java")));
        }
    }
}

