/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.launch.java.source.os;

import java.io.File;
import net.technicpack.launchercore.launch.java.IVersionSource;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.launch.java.version.FileBasedJavaRuntime;
import net.technicpack.utilslib.Utils;

public class WinRegistryJavaSource
implements IVersionSource {
    @Override
    public void enumerateVersions(JavaVersionRepository repository) {
        this.enumerateRegistryForBitness(repository, "32", "Software\\JavaSoft", "JavaHome");
        this.enumerateRegistryForBitness(repository, "64", "Software\\JavaSoft", "JavaHome");
        this.enumerateRegistryForBitness(repository, "32", "Software\\AdoptOpenJDK", "Path");
        this.enumerateRegistryForBitness(repository, "64", "Software\\AdoptOpenJDK", "Path");
        this.enumerateRegistryForBitness(repository, "32", "Software\\Eclipse Foundation", "Path");
        this.enumerateRegistryForBitness(repository, "64", "Software\\Eclipse Foundation", "Path");
        this.enumerateRegistryForBitness(repository, "32", "Software\\Eclipse Adoptium", "Path");
        this.enumerateRegistryForBitness(repository, "64", "Software\\Eclipse Adoptium", "Path");
        this.enumerateRegistryForBitness(repository, "64", "Software\\Microsoft\\JDK", "Path");
        this.enumerateRegistryForBitness(repository, "32", "Software\\Azul Systems\\Zulu", "InstallationPath");
        this.enumerateRegistryForBitness(repository, "64", "Software\\Azul Systems\\Zulu", "InstallationPath");
        this.enumerateRegistryForBitness(repository, "32", "Software\\BellSoft\\Liberica", "InstallationPath");
        this.enumerateRegistryForBitness(repository, "64", "Software\\BellSoft\\Liberica", "InstallationPath");
    }

    private void enumerateRegistryForBitness(JavaVersionRepository repository, String bitness, String keyPath, String keyName) {
        String output = Utils.getProcessOutput("reg", "query", "HKEY_LOCAL_MACHINE\\" + keyPath, "/f", keyName, "/t", "REG_SZ", "/s", "/reg:" + bitness);
        if (output == null || output.isEmpty()) {
            return;
        }
        for (String line : output.split("\\r?\\n")) {
            int typeIndex = line.indexOf("REG_SZ");
            if (typeIndex < 0) continue;
            String path = line.substring(typeIndex += "REG_SZ".length()).trim();
            repository.addVersion(new FileBasedJavaRuntime(new File(path + File.separator + "bin" + File.separator + "javaw.exe")));
        }
    }
}

