/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.launch.java.version;

import io.sentry.Sentry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.utilslib.ProfilingUtils;
import net.technicpack.utilslib.Utils;

public final class FileBasedJavaRuntime
implements IJavaRuntime,
Serializable {
    private transient boolean queried = false;
    private transient String version;
    private transient String vendor;
    private transient String osArch;
    private transient boolean is64Bit;
    private transient File javaPath;
    private String filePath;

    public FileBasedJavaRuntime(File javaPath) {
        this.filePath = Objects.requireNonNull(javaPath).getAbsolutePath();
        this.javaPath = new File(this.filePath);
    }

    public FileBasedJavaRuntime(String path) {
        Path absolutePath = Paths.get(Objects.requireNonNull(path), new String[0]).toAbsolutePath();
        this.javaPath = absolutePath.toFile();
        this.filePath = absolutePath.toString();
    }

    public FileBasedJavaRuntime(Path path) {
        Path absolutePath = Objects.requireNonNull(path).toAbsolutePath();
        this.javaPath = absolutePath.toFile();
        this.filePath = absolutePath.toString();
    }

    @Override
    public File getExecutableFile() {
        return this.javaPath;
    }

    @Override
    public String getVersion() {
        this.ensureQueried();
        return this.version;
    }

    private void ensureQueried() {
        if (!this.queried) {
            this.queried = true;
            ProfilingUtils.measureTime(String.format("Querying Java runtime \"%s\"", this.filePath), this::getInformationFromJavaRuntime);
        }
    }

    private void getInformationFromJavaRuntime() {
        String data;
        Path javaBinaryPath = Paths.get(this.filePath, new String[0]);
        if (javaBinaryPath.endsWith("javaw.exe")) {
            javaBinaryPath = javaBinaryPath.resolveSibling("java.exe");
        }
        if ((data = Utils.getProcessOutput(javaBinaryPath.toString(), "-XshowSettings:properties", "-version")) == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(data));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("java.version =")) {
                    this.version = line.substring("java.version =".length()).trim();
                    continue;
                }
                if (line.startsWith("java.vendor =")) {
                    this.vendor = line.substring("java.vendor =".length()).trim();
                    continue;
                }
                if (!line.startsWith("os.arch =")) continue;
                this.osArch = line.substring("os.arch =".length()).trim();
            }
        }
        catch (IOException ex) {
            Sentry.captureException(ex);
        }
        this.is64Bit = this.osArch != null && this.osArch.contains("64");
    }

    @Override
    public String getVendor() {
        this.ensureQueried();
        return this.vendor;
    }

    @Override
    public String getOsArch() {
        this.ensureQueried();
        return this.osArch;
    }

    @Override
    public String getBitness() {
        this.ensureQueried();
        return this.is64Bit ? "64" : "32";
    }

    @Override
    public boolean is64Bit() {
        this.ensureQueried();
        return this.is64Bit;
    }

    @Override
    public boolean isValid() {
        this.ensureQueried();
        return this.version != null && this.vendor != null && this.osArch != null;
    }

    public String getExecutablePath() {
        return this.filePath;
    }

    public int hashCode() {
        return Objects.hashCode(this.filePath);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBasedJavaRuntime that = (FileBasedJavaRuntime)o;
        return Objects.equals(this.filePath, that.filePath);
    }

    public String toString() {
        return "FileBasedJavaRuntime{queried=" + this.queried + ", version='" + this.version + '\'' + ", vendor='" + this.vendor + '\'' + ", osArch='" + this.osArch + '\'' + ", is64Bit=" + this.is64Bit + ", javaPath=" + this.javaPath + ", filePath='" + this.filePath + '\'' + '}';
    }
}

