/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class BuildLogFormatter
extends Formatter {
    private final SimpleDateFormat date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final String launcherBuild;

    public BuildLogFormatter(String launcherBuild) {
        this.launcherBuild = launcherBuild;
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder();
        builder.append("[B#").append(this.launcherBuild).append("] ");
        builder.append(this.date.format(record.getMillis()));
        builder.append(" [");
        builder.append(record.getLevel().getName().toUpperCase(Locale.ROOT));
        builder.append("] ");
        builder.append(this.formatMessage(record));
        if (builder.charAt(builder.length() - 1) != '\n') {
            builder.append('\n');
        }
        if (record.getThrown() != null) {
            StringWriter writer = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(writer));
            builder.append(writer.getBuffer());
        }
        return builder.toString();
    }
}

