/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.modpacks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.launchercore.install.ModpackVersion;
import net.technicpack.launchercore.modpacks.InstalledPack;
import net.technicpack.launchercore.modpacks.RunData;
import net.technicpack.launchercore.modpacks.packinfo.CombinedPackInfo;
import net.technicpack.launchercore.modpacks.sources.IInstalledPackRepository;
import net.technicpack.launchercore.modpacks.sources.IModpackTagBuilder;
import net.technicpack.platform.io.FeedItem;
import net.technicpack.platform.io.PlatformPackInfo;
import net.technicpack.rest.io.PackInfo;
import net.technicpack.rest.io.Resource;
import net.technicpack.solder.io.SolderPackInfo;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;

public class ModpackModel {
    private InstalledPack installedPack;
    private PackInfo packInfo;
    private IInstalledPackRepository installedPackRepository;
    private LauncherDirectories directories;
    private Collection<String> tags = new ArrayList<String>();
    private String buildName = "recommended";
    private boolean isPlatform = true;
    private File installedDirectory;
    private int priority = -2;

    public ModpackModel(InstalledPack installedPack, PackInfo info, IInstalledPackRepository installedPackRepository, LauncherDirectories directories) {
        this();
        this.installedPack = installedPack;
        this.packInfo = info;
        this.installedPackRepository = installedPackRepository;
        this.directories = directories;
    }

    protected ModpackModel() {
    }

    public boolean isOfficial() {
        if (this.packInfo == null) {
            return false;
        }
        return this.packInfo.isOfficial();
    }

    public InstalledPack getInstalledPack() {
        return this.installedPack;
    }

    public PackInfo getPackInfo() {
        return this.packInfo;
    }

    public void setInstalledPack(InstalledPack pack, IInstalledPackRepository packRepo) {
        this.installedPack = pack;
        this.installedPackRepository = packRepo;
    }

    public void setPackInfo(PackInfo packInfo) {
        this.packInfo = packInfo instanceof SolderPackInfo && this.packInfo instanceof PlatformPackInfo ? new CombinedPackInfo(packInfo, this.packInfo) : (packInfo instanceof PlatformPackInfo && this.packInfo instanceof SolderPackInfo ? new CombinedPackInfo(this.packInfo, packInfo) : (packInfo instanceof SolderPackInfo && this.packInfo instanceof CombinedPackInfo ? new CombinedPackInfo(packInfo, this.packInfo) : (packInfo instanceof PlatformPackInfo && this.packInfo instanceof CombinedPackInfo ? new CombinedPackInfo(this.packInfo, packInfo) : packInfo)));
    }

    public String getDiscordId() {
        if (this.packInfo != null) {
            return this.packInfo.getDiscordId();
        }
        return null;
    }

    public String getName() {
        if (this.packInfo != null) {
            return this.packInfo.getName();
        }
        if (this.installedPack != null) {
            return this.installedPack.getName();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.packInfo != null) {
            return this.packInfo.getDisplayName();
        }
        if (this.installedPack != null) {
            return this.installedPack.getName();
        }
        return "";
    }

    public void setBuild(String build) {
        if (this.installedPack != null) {
            this.installedPack.setBuild(build);
            this.save();
        } else {
            this.buildName = build;
        }
    }

    public String getBuild() {
        if (this.installedPack != null) {
            return this.installedPack.getBuild();
        }
        return this.buildName;
    }

    public List<String> getBuilds() {
        if (this.packInfo != null && this.packInfo.getBuilds() != null) {
            return this.packInfo.getBuilds();
        }
        ArrayList<String> oneBuild = new ArrayList<String>(1);
        ModpackVersion version = this.getInstalledVersion();
        if (version != null) {
            oneBuild.add(version.getVersion());
        } else {
            oneBuild.add(this.getBuild());
        }
        return oneBuild;
    }

    public String getRecommendedBuild() {
        if (this.packInfo != null && this.packInfo.getRecommended() != null) {
            return this.packInfo.getRecommended();
        }
        return this.getBuild();
    }

    public String getLatestBuild() {
        if (this.packInfo != null && this.packInfo.getLatest() != null) {
            return this.packInfo.getLatest();
        }
        return this.getBuild();
    }

    public String getWebSite() {
        if (this.getPackInfo() == null) {
            return null;
        }
        return this.getPackInfo().getWebSite();
    }

    public Resource getIcon() {
        if (this.packInfo == null) {
            return null;
        }
        return this.packInfo.getIcon();
    }

    public Resource getLogo() {
        if (this.packInfo == null) {
            return null;
        }
        return this.packInfo.getLogo();
    }

    public Resource getBackground() {
        if (this.packInfo == null) {
            return null;
        }
        return this.packInfo.getBackground();
    }

    public List<FeedItem> getFeed() {
        if (this.packInfo == null) {
            return Collections.emptyList();
        }
        return this.packInfo.getFeed();
    }

    public boolean isLocalOnly() {
        if (this.packInfo == null) {
            return true;
        }
        return this.packInfo.isLocal();
    }

    public ModpackVersion getInstalledVersion() {
        File versionFile = new File(this.getBinDir(), "version");
        if (versionFile.exists()) {
            return ModpackVersion.load(versionFile);
        }
        return null;
    }

    public boolean hasRecommendedUpdate() {
        if (this.installedPack == null || this.packInfo == null) {
            return false;
        }
        ModpackVersion installedVersion = this.getInstalledVersion();
        if (installedVersion == null) {
            return false;
        }
        String installedBuild = installedVersion.getVersion();
        List<String> allBuilds = this.packInfo.getBuilds();
        if (allBuilds.isEmpty()) {
            return false;
        }
        if (!allBuilds.contains(installedBuild)) {
            return true;
        }
        for (String build : allBuilds) {
            if (build.equalsIgnoreCase(this.packInfo.getRecommended())) {
                return false;
            }
            if (!build.equalsIgnoreCase(installedBuild)) continue;
            return true;
        }
        return false;
    }

    public void setIsPlatform(boolean isPlatform) {
        if (this.installedPack == null) {
            this.isPlatform = isPlatform;
        }
    }

    public String getDescription() {
        if (this.packInfo == null) {
            return "";
        }
        return this.packInfo.getDescription();
    }

    public boolean isServerPack() {
        if (this.packInfo == null) {
            return false;
        }
        return this.packInfo.isServerPack();
    }

    public Integer getLikes() {
        if (this.packInfo == null) {
            return null;
        }
        return this.packInfo.getLikes();
    }

    public Integer getRuns() {
        if (this.packInfo == null) {
            return null;
        }
        return this.packInfo.getRuns();
    }

    public Integer getInstalls() {
        if (this.packInfo == null) {
            return null;
        }
        return this.packInfo.getInstalls();
    }

    public RunData getRunData() {
        String runData;
        File runDataFile = new File(this.getBinDir(), "runData");
        if (!runDataFile.exists()) {
            return null;
        }
        try {
            runData = FileUtils.readFileToString(runDataFile, StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            return null;
        }
        return Utils.getGson().fromJson(runData, RunData.class);
    }

    public File getInstalledDirectory() {
        if (this.installedPack == null) {
            return null;
        }
        if (this.installedDirectory == null) {
            String rawDir = this.installedPack.getDirectory();
            if (rawDir != null && rawDir.startsWith("launcher\\")) {
                rawDir = new File(this.directories.getLauncherDirectory(), rawDir.substring("launcher\\".length())).getAbsolutePath();
            }
            if (rawDir != null && rawDir.startsWith("%MODPACKS%\\")) {
                rawDir = new File(this.directories.getModpacksDirectory(), rawDir.substring("%MODPACKS%\\".length())).getAbsolutePath();
            }
            this.setInstalledDirectory(new File(rawDir));
        }
        return this.installedDirectory;
    }

    public File getBinDir() {
        File installedDir = this.getInstalledDirectory();
        if (installedDir == null) {
            return null;
        }
        return new File(installedDir, "bin");
    }

    public File getModsDir() {
        File installedDir = this.getInstalledDirectory();
        if (installedDir == null) {
            return null;
        }
        return new File(installedDir, "mods");
    }

    public File getCoremodsDir() {
        File installedDir = this.getInstalledDirectory();
        if (installedDir == null) {
            return null;
        }
        return new File(installedDir, "coremods");
    }

    public File getCacheDir() {
        File installedDir = this.getInstalledDirectory();
        if (installedDir == null) {
            return null;
        }
        return new File(installedDir, "cache");
    }

    public File getConfigDir() {
        File installedDir = this.getInstalledDirectory();
        if (installedDir == null) {
            return null;
        }
        return new File(installedDir, "config");
    }

    public File getResourcesDir() {
        File installedDir = this.getInstalledDirectory();
        if (installedDir == null) {
            return null;
        }
        return new File(installedDir, "resources");
    }

    public File getSavesDir() {
        File installedDir = this.getInstalledDirectory();
        if (installedDir == null) {
            return null;
        }
        return new File(installedDir, "saves");
    }

    public void initDirectories() {
        this.getBinDir().mkdirs();
        this.getModsDir().mkdirs();
        this.getCoremodsDir().mkdirs();
        this.getConfigDir().mkdirs();
        this.getCacheDir().mkdirs();
        this.getResourcesDir().mkdirs();
        this.getSavesDir().mkdirs();
    }

    public void setInstalledDirectory(File targetDirectory) {
        if (this.installedDirectory != null && this.installedDirectory.exists()) {
            try {
                FileUtils.copyDirectory(this.installedDirectory, targetDirectory);
                FileUtils.cleanDirectory(this.installedDirectory);
            }
            catch (IOException ex) {
                Utils.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                return;
            }
        }
        this.installedDirectory = targetDirectory;
        String path = this.installedDirectory.getAbsolutePath();
        String newInstalledPackDir = path.equals(this.directories.getModpacksDirectory().getAbsolutePath()) ? "%MODPACKS%\\" : (path.equals(this.directories.getLauncherDirectory().getAbsolutePath()) ? "launcher\\" : (path.startsWith(this.directories.getModpacksDirectory().getAbsolutePath()) ? "%MODPACKS%\\" + path.substring(this.directories.getModpacksDirectory().getAbsolutePath().length() + 1) : (path.startsWith(this.directories.getLauncherDirectory().getAbsolutePath()) ? "launcher\\" + path.substring(this.directories.getLauncherDirectory().getAbsolutePath().length() + 1) : path)));
        if (!newInstalledPackDir.equals(this.installedPack.getDirectory())) {
            this.installedPack.setDirectory(newInstalledPackDir);
            this.save();
        }
    }

    public void save() {
        if (this.installedPack == null) {
            this.installedPack = new InstalledPack(this.getName(), this.getBuild());
        }
        this.installedPackRepository.put(this.installedPack);
    }

    public boolean isSelected() {
        String selectedSlug = this.installedPackRepository.getSelectedSlug();
        if (selectedSlug == null) {
            this.select();
        }
        return selectedSlug == null || selectedSlug.equalsIgnoreCase(this.getName());
    }

    public void select() {
        String storedSelection = this.installedPackRepository.getSelectedSlug();
        String name = this.getName();
        if (name == null) {
            return;
        }
        if (storedSelection == null || !storedSelection.equals(name)) {
            this.installedPackRepository.setSelectedSlug(name);
        }
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public void updateTags(IModpackTagBuilder tagBuilder) {
        this.tags.clear();
        if (tagBuilder != null) {
            for (String tag : tagBuilder.getModpackTags(this)) {
                this.tags.add(tag);
            }
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void updatePriority(int priority) {
        if (this.priority < priority) {
            this.priority = priority;
        }
        if (this.priority == -1 && this.packInfo != null && this.packInfo.isComplete()) {
            this.priority = this.packInfo.isOfficial() ? 5000 : 1000;
        }
    }

    public void resetPack() {
        File version;
        if (this.installedPack != null && this.getBinDir() != null && (version = new File(this.getBinDir(), "version")).exists()) {
            version.delete();
        }
    }

    public void delete() {
        File assets;
        if (this.getInstalledDirectory() != null && this.getInstalledDirectory().exists()) {
            try {
                FileUtils.deleteDirectory(this.getInstalledDirectory());
            }
            catch (IOException ex) {
                Utils.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if ((assets = new File(this.directories.getAssetsDirectory(), this.getName())).exists()) {
            try {
                FileUtils.deleteDirectory(assets);
            }
            catch (IOException ex) {
                Utils.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.installedPackRepository.remove(this.getName());
        this.installedPack = null;
        this.installedDirectory = null;
    }
}

