/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.modpacks;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.launchercore.modpacks.IModpackContainer;
import net.technicpack.launchercore.modpacks.InstalledPack;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.sources.IAuthoritativePackSource;
import net.technicpack.launchercore.modpacks.sources.IInstalledPackRepository;
import net.technicpack.launchercore.modpacks.sources.IModpackTagBuilder;
import net.technicpack.launchercore.modpacks.sources.IPackSource;
import net.technicpack.rest.io.PackInfo;

public class PackLoadJob
implements Runnable {
    private LauncherDirectories directories;
    private IModpackTagBuilder tagBuilder;
    private IAuthoritativePackSource authoritativeSource;
    private IInstalledPackRepository packRepository;
    private Collection<IPackSource> packSources;
    private IModpackContainer container;
    private boolean doLoadRepository;
    private Map<String, ModpackModel> processedModpacks = new HashMap<String, ModpackModel>();
    private boolean isCancelled = false;

    public PackLoadJob(LauncherDirectories directories, IInstalledPackRepository packRepository, IAuthoritativePackSource authoritativeSource, Collection<IPackSource> packSources, IModpackContainer container, IModpackTagBuilder tagBuilder, boolean doLoadRepository) {
        this.packRepository = packRepository;
        this.authoritativeSource = authoritativeSource;
        this.packSources = packSources;
        this.container = container;
        this.tagBuilder = tagBuilder;
        this.directories = directories;
        this.doLoadRepository = doLoadRepository;
        container.clear();
    }

    public void cancel() {
        if (EventQueue.isDispatchThread()) {
            this.isCancelled = true;
        } else {
            EventQueue.invokeLater(this::cancel);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void run() {
        int threadCount = 0;
        if (this.doLoadRepository) {
            ++threadCount;
        }
        if (this.packSources != null) {
            threadCount += this.packSources.size();
        }
        ArrayList<1> threads = new ArrayList<1>(threadCount);
        if (this.doLoadRepository) {
            for (String string : this.packRepository.getPackNames()) {
                InstalledPack pack = this.packRepository.getInstalledPacks().get(string);
                this.addPackThreadSafe(pack, null, -1);
            }
        }
        if (this.packSources != null) {
            for (final IPackSource iPackSource : this.packSources) {
                Thread packSourceThread = new Thread(iPackSource.getSourceName() + " Loading Thread"){

                    @Override
                    public void run() {
                        for (PackInfo info : iPackSource.getPublicPacks()) {
                            PackLoadJob.this.addPackThreadSafe(null, info, iPackSource.getPriority(info));
                        }
                    }
                };
                threads.add(packSourceThread);
                packSourceThread.start();
            }
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.refreshCompleteThreadSafe();
    }

    protected void refreshCompleteThreadSafe() {
        EventQueue.invokeLater(() -> this.container.refreshComplete());
    }

    protected void addPackThreadSafe(InstalledPack pack, PackInfo packInfo, int priority) {
        EventQueue.invokeLater(() -> this.addPack(pack, packInfo, priority));
    }

    protected void addPack(InstalledPack pack, PackInfo packInfo, int priority) {
        ModpackModel modpack;
        if (pack == null && packInfo == null || this.isCancelled) {
            return;
        }
        String name = pack != null ? pack.getName() : packInfo.getName();
        boolean newModpackModel = true;
        if (this.processedModpacks.containsKey(name)) {
            modpack = this.processedModpacks.get(name);
            newModpackModel = false;
            if (modpack.getInstalledPack() == null && pack != null) {
                modpack.setInstalledPack(pack, this.packRepository);
            }
            if (packInfo != null) {
                modpack.setPackInfo(packInfo);
                modpack.updatePriority(priority);
            }
        } else {
            modpack = new ModpackModel(pack, packInfo, this.packRepository, this.directories);
            modpack.updatePriority(priority);
            if (packInfo == null) {
                modpack.setIsPlatform(false);
            }
            this.processedModpacks.put(name, modpack);
        }
        if (modpack.getInstalledPack() == null && !this.doLoadRepository && this.packRepository.getInstalledPacks().containsKey(modpack.getName())) {
            modpack.setInstalledPack(this.packRepository.getInstalledPacks().get(modpack.getName()), this.packRepository);
        }
        Runnable fillDataMethod = null;
        if (modpack.getPackInfo() == null) {
            fillDataMethod = () -> {
                PackInfo completeInfo = this.authoritativeSource.getPackInfo(pack);
                if (completeInfo != null) {
                    this.addPackThreadSafe(null, completeInfo, priority);
                }
            };
        } else if (!modpack.getPackInfo().isComplete()) {
            fillDataMethod = () -> {
                PackInfo completeInfo = this.authoritativeSource.getCompletePackInfo(packInfo);
                if (completeInfo != null) {
                    this.addPackThreadSafe(null, completeInfo, priority);
                }
            };
        }
        if (fillDataMethod != null) {
            Thread thread = new Thread(fillDataMethod);
            thread.start();
        }
        if (modpack != null && this.tagBuilder != null) {
            modpack.updateTags(this.tagBuilder);
        }
        if (newModpackModel) {
            this.container.addModpackToContainer(modpack);
        } else {
            this.container.replaceModpackInContainer(modpack);
        }
    }
}

