/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.modpacks.resources;

import java.awt.image.BufferedImage;
import java.io.File;
import net.technicpack.launchercore.image.IImageMapper;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.resources.resourcetype.IModpackResourceType;
import net.technicpack.rest.io.Resource;
import net.technicpack.utilslib.CryptoUtils;

public class PackResourceMapper
implements IImageMapper<ModpackModel> {
    private LauncherDirectories directories;
    private BufferedImage defaultImage;
    private IModpackResourceType resourceType;

    public PackResourceMapper(LauncherDirectories directories, BufferedImage defaultImage, IModpackResourceType resourceType) {
        this.directories = directories;
        this.defaultImage = defaultImage;
        this.resourceType = resourceType;
    }

    @Override
    public boolean shouldDownloadImage(ModpackModel imageKey) {
        Resource res = this.resourceType.getResource(imageKey);
        if (res == null) {
            return false;
        }
        String md5 = res.getMd5();
        if (md5 == null || md5.isEmpty()) {
            return true;
        }
        return !CryptoUtils.checkMD5(this.getImageLocation(imageKey), md5);
    }

    @Override
    public File getImageLocation(ModpackModel imageKey) {
        File assets = new File(this.directories.getAssetsDirectory(), "packs");
        File packs = new File(assets, imageKey.getName());
        return new File(packs, this.resourceType.getImageName());
    }

    @Override
    public BufferedImage getDefaultImage() {
        return this.defaultImage;
    }
}

