/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v5.Apache5HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.technicpack.launcher.io.IUserTypeInstanceCreator;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.util.DownloadListener;
import net.technicpack.minecraftcore.mojang.java.JavaRuntimesIndex;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.io.CompleteVersion;
import net.technicpack.minecraftcore.mojang.version.io.CompleteVersionV21;
import net.technicpack.minecraftcore.mojang.version.io.Rule;
import net.technicpack.minecraftcore.mojang.version.io.RuleAdapter;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentList;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentListAdapter;
import net.technicpack.utilslib.DateTypeAdapter;
import net.technicpack.utilslib.LowerCaseEnumTypeAdapterFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class MojangUtils {
    private static final HttpTransport HTTP_TRANSPORT = new Apache5HttpTransport();
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private static final HttpRequestFactory REQUEST_FACTORY;
    public static final String assets = "https://resources.download.minecraft.net/";
    public static final String RUNTIMES_URL = "https://launchermeta.mojang.com/v1/products/java-runtime/2ec0cc96c44e5a76b9c8b7c39df7210883d12871/all.json";
    private static JavaRuntimesIndex javaRuntimesIndex;
    private static final Gson gson;
    private static final NavigableMap<Integer, Class<? extends MojangVersion>> versionJsonVersions;

    public static String getResourceUrl(String hash) {
        return assets + hash.substring(0, 2) + "/" + hash;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void copyMinecraftJar(File minecraft, File output, DownloadListener listener) throws IOException {
        String[] security = new String[]{"MOJANG_C.DSA", "MOJANG_C.SF", "CODESIGN.RSA", "CODESIGN.SF"};
        Pattern securityPattern = Pattern.compile(Arrays.stream(security).map(Pattern::quote).collect(Collectors.joining("|")));
        listener.stateChanged("Processing Minecraft jar", 0.0f);
        try (JarFile jarFile = new JarFile(minecraft);
             OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             JarOutputStream jos = new JarOutputStream(out);){
            Enumeration<JarEntry> entries = jarFile.entries();
            int totalEntries = jarFile.size();
            int x = 1;
            while (entries.hasMoreElements()) {
                listener.stateChanged("Processing Minecraft jar", (float)x / (float)totalEntries * 100.0f);
                JarEntry entry = entries.nextElement();
                if (securityPattern.matcher(entry.getName()).find()) continue;
                try (InputStream is = jarFile.getInputStream(entry);){
                    int bytesRead;
                    jos.putNextEntry(new JarEntry(entry.getName()));
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        jos.write(buffer, 0, bytesRead);
                    }
                }
                jos.flush();
                jos.closeEntry();
                ++x;
            }
        }
    }

    public static MojangVersion parseVersionJson(String json) {
        Class versionJsonType;
        JsonObject root = JsonParser.parseString(json).getAsJsonObject();
        if (root.has("world_version") && root.has("protocol_version")) {
            throw new IllegalArgumentException("Invalid version file, this looks like a Minecraft client jar. Are you sure you didn't place a Minecraft jar as the modpack.jar?");
        }
        if (root.has("minimumLauncherVersion")) {
            int minLauncherVersion = root.get("minimumLauncherVersion").getAsInt();
            Map.Entry<Integer, Class<? extends MojangVersion>> entry = versionJsonVersions.floorEntry(minLauncherVersion);
            if (entry == null) {
                throw new IllegalArgumentException("Unsupported minimumLauncherVersion: " + minLauncherVersion);
            }
            versionJsonType = entry.getValue();
        } else {
            versionJsonType = root.has("arguments") ? CompleteVersionV21.class : CompleteVersion.class;
        }
        return MojangUtils.getGson().fromJson((JsonElement)root, versionJsonType);
    }

    public static boolean isLegacyVersion(String version) {
        String[] versionParts = version.split("[.-]", 3);
        return Integer.parseInt(versionParts[0]) == 1 && Integer.parseInt(versionParts[1]) < 6;
    }

    public static boolean hasModernMinecraftForge(MojangVersion version) {
        Pattern p = Pattern.compile("^(?<mc>[0-9.]+)-forge-(?<forge>[0-9.]+)$");
        Matcher m = p.matcher(version.getId());
        if (!m.matches()) {
            return false;
        }
        String mcVersionString = m.group("mc");
        ComparableVersion mcVersion = new ComparableVersion(mcVersionString);
        ComparableVersion forgeVersion = new ComparableVersion(m.group("forge"));
        if (mcVersion.compareTo(new ComparableVersion("1.13")) >= 0) {
            return true;
        }
        return mcVersionString.equals("1.12.2") && forgeVersion.compareTo(new ComparableVersion("14.23.5.2847")) > 0;
    }

    public static boolean hasNeoForge(MojangVersion version) {
        Pattern p = Pattern.compile("^neoforge-(?<forge>[0-9.]+)");
        Matcher m = p.matcher(version.getId());
        return m.lookingAt();
    }

    public static String getMinecraftVersion(MojangVersion version) {
        String id = version.getId();
        if (!id.contains("-")) {
            return id;
        }
        if (MojangUtils.hasNeoForge(version)) {
            return version.getParentVersion();
        }
        String[] idParts = id.split("-");
        return idParts[0];
    }

    public static boolean requiresForgeWrapper(MojangVersion version) {
        if (MojangUtils.hasNeoForge(version)) {
            return true;
        }
        if (!MojangUtils.hasModernMinecraftForge(version)) {
            return false;
        }
        String mcVersion = MojangUtils.getMinecraftVersion(version);
        return !mcVersion.equals("1.12.2");
    }

    public static JavaRuntimesIndex getJavaRuntimesIndex() {
        if (javaRuntimesIndex != null) {
            return javaRuntimesIndex;
        }
        try {
            HttpRequest request = REQUEST_FACTORY.buildGetRequest(new GenericUrl(RUNTIMES_URL));
            HttpResponse httpResponse = request.execute();
            javaRuntimesIndex = gson.fromJson(httpResponse.parseAsString(), JavaRuntimesIndex.class);
            return javaRuntimesIndex;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)ArgumentList.class), new ArgumentListAdapter());
        builder.registerTypeAdapter((Type)((Object)Rule.class), new RuleAdapter());
        builder.registerTypeAdapter((Type)((Object)IUserType.class), new IUserTypeInstanceCreator());
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        gson = builder.create();
        versionJsonVersions = new TreeMap<Integer, Class<? extends MojangVersion>>();
        versionJsonVersions.put(0, CompleteVersion.class);
        versionJsonVersions.put(21, CompleteVersionV21.class);
        REQUEST_FACTORY = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser(new JsonObjectParser(JSON_FACTORY)));
    }
}

