/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.rest.io.Mod;
import net.technicpack.rest.io.Modpack;
import org.apache.commons.io.FileUtils;

public class CleanupModpackCacheTask
implements IInstallTask<MojangVersion> {
    private ModpackModel pack;
    private Modpack modpack;

    public CleanupModpackCacheTask(ModpackModel pack, Modpack modpack) {
        this.pack = pack;
        this.modpack = modpack;
    }

    @Override
    public String getTaskDescription() {
        return "Cleaning Modpack Cache";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<MojangVersion> queue) throws IOException {
        File cacheDir = this.pack.getCacheDir();
        File[] files = cacheDir.listFiles();
        if (files == null) {
            return;
        }
        HashSet<File> keepFiles = new HashSet<File>(this.modpack.getMods().size());
        for (Mod mod : this.modpack.getMods()) {
            keepFiles.add(mod.generateSafeCacheFile(cacheDir));
        }
        for (File file : files) {
            if (keepFiles.contains(file)) continue;
            FileUtils.deleteQuietly(file);
        }
    }
}

