/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.technicpack.launchercore.TechnicConstants;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.install.tasks.InstallVersionLibTask;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.MojangVersionBuilder;
import net.technicpack.minecraftcore.mojang.version.builder.FileVersionBuilder;
import net.technicpack.minecraftcore.mojang.version.builder.retrievers.ZipFileRetriever;
import net.technicpack.minecraftcore.mojang.version.io.Artifact;
import net.technicpack.minecraftcore.mojang.version.io.Downloads;
import net.technicpack.minecraftcore.mojang.version.io.Library;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class HandleVersionFileTask
implements IInstallTask<MojangVersion> {
    private ModpackModel pack;
    private LauncherDirectories directories;
    private ITasksQueue<MojangVersion> checkLibraryQueue;
    private ITasksQueue<MojangVersion> downloadLibraryQueue;
    private ITasksQueue<MojangVersion> copyLibraryQueue;
    private ITasksQueue<MojangVersion> checkNonMavenLibsQueue;
    private MojangVersionBuilder versionBuilder;
    private ILaunchOptions launchOptions;
    private IJavaRuntime javaRuntime;
    private String libraryName;

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public HandleVersionFileTask withPack(ModpackModel pack) {
        this.pack = pack;
        return this;
    }

    public HandleVersionFileTask withDirectories(LauncherDirectories directories) {
        this.directories = directories;
        return this;
    }

    public HandleVersionFileTask withCheckLibraryQueue(ITasksQueue<MojangVersion> checkLibraryQueue) {
        this.checkLibraryQueue = checkLibraryQueue;
        return this;
    }

    public HandleVersionFileTask withDownloadLibraryQueue(ITasksQueue<MojangVersion> downloadLibraryQueue) {
        this.downloadLibraryQueue = downloadLibraryQueue;
        return this;
    }

    public HandleVersionFileTask withCopyLibraryQueue(ITasksQueue<MojangVersion> copyLibraryQueue) {
        this.copyLibraryQueue = copyLibraryQueue;
        return this;
    }

    public HandleVersionFileTask withCheckNonMavenLibsQueue(ITasksQueue<MojangVersion> checkNonMavenLibsQueue) {
        this.checkNonMavenLibsQueue = checkNonMavenLibsQueue;
        return this;
    }

    public HandleVersionFileTask withVersionBuilder(MojangVersionBuilder versionBuilder) {
        this.versionBuilder = versionBuilder;
        return this;
    }

    public HandleVersionFileTask withLaunchOptions(ILaunchOptions launchOptions) {
        this.launchOptions = launchOptions;
        return this;
    }

    public HandleVersionFileTask withJavaRuntime(IJavaRuntime javaRuntime) {
        this.javaRuntime = javaRuntime;
        return this;
    }

    @Override
    public String getTaskDescription() {
        if (this.libraryName == null) {
            return "Processing version.";
        }
        return "Verifying " + this.libraryName + ".";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<MojangVersion> queue) throws IOException, InterruptedException {
        Objects.requireNonNull(this.pack, "ModpackModel must be set.");
        Objects.requireNonNull(this.directories, "LauncherDirectories must be set.");
        Objects.requireNonNull(this.checkLibraryQueue, "CheckLibraryQueue must be set.");
        Objects.requireNonNull(this.downloadLibraryQueue, "DownloadLibraryQueue must be set.");
        Objects.requireNonNull(this.copyLibraryQueue, "CopyLibraryQueue must be set.");
        Objects.requireNonNull(this.checkNonMavenLibsQueue, "CheckNonMavenLibsQueue must be set.");
        Objects.requireNonNull(this.versionBuilder, "VersionBuilder must be set.");
        Objects.requireNonNull(this.launchOptions, "LaunchOptions must be set.");
        Objects.requireNonNull(this.javaRuntime, "JavaRuntime must be set.");
        MojangVersion version = this.versionBuilder.buildVersionFromKey(null);
        if (version == null) {
            throw new DownloadException("The version.json file was invalid.");
        }
        version.setJavaRuntime(this.javaRuntime);
        boolean isLegacy = MojangUtils.isLegacyVersion(version.getParentVersion());
        if (isLegacy) {
            Library legacyWrapper = new Library("net.technicpack:legacywrapper:1.2.1", TechnicConstants.TECHNIC_LIB_REPO + "net/technicpack/legacywrapper/1.2.1/legacywrapper-1.2.1.jar", "741cbc946421a5a59188a51108e1ce5cb5674681", 77327);
            version.addLibrary(legacyWrapper);
            version.setMainClass("net.technicpack.legacywrapper.Launch");
        }
        boolean hasNeoForge = MojangUtils.hasNeoForge(version);
        boolean hasModernMinecraftForge = MojangUtils.hasModernMinecraftForge(version);
        if (hasModernMinecraftForge || hasNeoForge) {
            Artifact artifact;
            Downloads downloads;
            File profileJson = new File(this.pack.getBinDir(), "install_profile.json");
            ZipFileRetriever zipVersionRetriever = new ZipFileRetriever(new File(this.pack.getBinDir(), "modpack.jar"));
            MojangVersion installerVersion = new FileVersionBuilder(profileJson, zipVersionRetriever, null).buildVersionFromKey("install_profile");
            String[] versionIdParts = version.getId().split("-", 3);
            boolean is1_12_2 = versionIdParts[0].equals("1.12.2");
            if (is1_12_2) {
                for (Library library : version.getLibrariesForCurrentOS(this.launchOptions, this.javaRuntime)) {
                    if (!library.getGradleGroup().equals("net.minecraftforge") || !library.getGradleArtifact().equals("forge") || library.getGradleClassifier() != null && !library.getGradleClassifier().isEmpty()) continue;
                    String oldName = library.getName();
                    library.setName(library.getName() + ":universal");
                    downloads = library.getDownloads();
                    artifact = downloads.getArtifact();
                    artifact.setUrl("https://maven.minecraftforge.net/" + library.getArtifactPath());
                    library.setName(oldName);
                    break;
                }
            }
            List dedupedInstallerLibraries = installerVersion.getLibraries().stream().filter(HandleVersionFileTask.distinctByKey(Library::getName)).collect(Collectors.toList());
            for (Object library : dedupedInstallerLibraries) {
                if (((Library)library).isMinecraftForge() && is1_12_2) continue;
                if (((Library)library).getGradleGroup().equals("net.minecraftforge") && ((Library)library).getGradleArtifact().equals("forge") && ((Library)library).getGradleClassifier() != null && ((Library)library).getGradleClassifier().equals("universal") && !is1_12_2 && ((artifact = (downloads = ((Library)library).getDownloads()).getArtifact()).getUrl() == null || artifact.getUrl().isEmpty())) {
                    artifact.setUrl("https://maven.minecraftforge.net/" + ((Library)library).getArtifactPath());
                }
                this.checkLibraryQueue.addTask(new InstallVersionLibTask((Library)library, this.checkNonMavenLibsQueue, this.downloadLibraryQueue, this.copyLibraryQueue, this.pack, this.directories));
            }
            if (!is1_12_2) {
                Library library = new Library("io.github.zekerzhayard:ForgeWrapper:1.6.0-technic", TechnicConstants.TECHNIC_LIB_REPO + "io/github/zekerzhayard/ForgeWrapper/1.6.0-technic/ForgeWrapper-1.6.0-technic.jar", "8764cbf4c7ded7ac0ad9136a0070bbfeee8813cf", 34944);
                version.prependLibrary(library);
                version.setMainClass("io.github.zekerzhayard.forgewrapper.installer.Main");
                for (Library library2 : version.getLibrariesForCurrentOS(this.launchOptions, this.javaRuntime)) {
                    if (library2.getGradleGroup().equals("net.minecraftforge") && library2.getGradleArtifact().equals("forge") && (library2.getGradleClassifier() == null || library2.getGradleClassifier().isEmpty())) {
                        String oldName = library2.getName();
                        library2.setName(library2.getName() + ":launcher");
                        Downloads downloads2 = library2.getDownloads();
                        Artifact artifact2 = downloads2.getArtifact();
                        if (artifact2.getUrl() == null || artifact2.getUrl().isEmpty()) {
                            artifact2.setUrl("https://maven.minecraftforge.net/" + library2.getArtifactPath());
                        }
                        library2.setName(oldName);
                        break;
                    }
                    if (!library2.getGradleGroup().equals("net.minecraftforge") || !library2.getGradleArtifact().equals("forge") || library2.getGradleClassifier() == null || !library2.getGradleClassifier().equals("client")) continue;
                    version.removeLibrary(library2.getName());
                }
            }
        }
        for (Library library : version.getLibrariesForCurrentOS(this.launchOptions, this.javaRuntime)) {
            if (library.isMinecraftForge() && !hasModernMinecraftForge) {
                version.removeLibrary(library.getName());
                continue;
            }
            if (isLegacy && library.getName().startsWith("net.minecraft:launchwrapper:")) {
                version.removeLibrary(library.getName());
                continue;
            }
            if (library.isLog4j() && new ComparableVersion(library.getGradleVersion()).compareTo(new ComparableVersion("2.16.0")) < 0) {
                int size;
                String sha1;
                String[] libNameParts = library.getName().split(":");
                String log4jVersion = "2.16.0";
                if (libNameParts[2].equals("2.0-beta9")) {
                    log4jVersion = "2.0-beta9-fixed";
                }
                String string = libNameParts[1];
                block4 : switch (log4jVersion) {
                    case "2.16.0": {
                        switch (string) {
                            case "log4j-api": {
                                sha1 = "f821a18687126c2e2f227038f540e7953ad2cc8c";
                                size = 301892;
                                break block4;
                            }
                            case "log4j-core": {
                                sha1 = "539a445388aee52108700f26d9644989e7916e7c";
                                size = 1789565;
                                break block4;
                            }
                            case "log4j-slf4j18-impl": {
                                sha1 = "0c880a059056df5725f5d8d1035276d9749eba6d";
                                size = 21249;
                                break block4;
                            }
                        }
                        throw new RuntimeException("Unknown log4j artifact " + string + ", cannot continue");
                    }
                    case "2.0-beta9-fixed": {
                        switch (string) {
                            case "log4j-api": {
                                sha1 = "b61eaf2e64d8b0277e188262a8b771bbfa1502b3";
                                size = 107347;
                                break block4;
                            }
                            case "log4j-core": {
                                sha1 = "677991ea2d7426f76309a73739cecf609679492c";
                                size = 677588;
                                break block4;
                            }
                        }
                        throw new RuntimeException("Unknown log4j artifact " + string + ", cannot continue");
                    }
                    default: {
                        throw new RuntimeException("Unknown log4j version " + log4jVersion + ", cannot continue");
                    }
                }
                String url = String.format(TechnicConstants.TECHNIC_LIB_REPO + "org/apache/logging/log4j/%1$s/%2$s/%1$s-%2$s.jar", string, log4jVersion);
                Library fixedLog4j = new Library("org.apache.logging.log4j:" + string + ":" + log4jVersion, url, sha1, size);
                version.addLibrary(fixedLog4j);
                this.checkLibraryQueue.addTask(new InstallVersionLibTask(fixedLog4j, this.checkNonMavenLibsQueue, this.downloadLibraryQueue, this.copyLibraryQueue, this.pack, this.directories));
                version.removeLibrary(library.getName());
                continue;
            }
            this.checkLibraryQueue.addTask(new InstallVersionLibTask(library, this.checkNonMavenLibsQueue, this.downloadLibraryQueue, this.copyLibraryQueue, this.pack, this.directories));
        }
        queue.setMetadata(version);
    }
}

