/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.technicpack.launchercore.TechnicConstants;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.launchercore.install.tasks.CopyFileTask;
import net.technicpack.launchercore.install.tasks.EnsureFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.FmlLibsManager;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.rest.io.Modpack;

public class InstallFmlLibsTask
implements IInstallTask<MojangVersion> {
    private final ModpackModel pack;
    private final LauncherDirectories directories;
    private final Modpack modpack;
    private final ITasksQueue<MojangVersion> verifyingFiles;
    private final ITasksQueue<MojangVersion> downloadLibraryQueue;
    private final ITasksQueue<MojangVersion> copyLibraryQueue;

    public InstallFmlLibsTask(ModpackModel pack, LauncherDirectories directories, Modpack modpack, ITasksQueue<MojangVersion> verifyingFiles, ITasksQueue<MojangVersion> downloadLibraryQueue, ITasksQueue<MojangVersion> copyLibraryQueue) {
        this.pack = pack;
        this.directories = directories;
        this.modpack = modpack;
        this.verifyingFiles = verifyingFiles;
        this.downloadLibraryQueue = downloadLibraryQueue;
        this.copyLibraryQueue = copyLibraryQueue;
    }

    @Override
    public String getTaskDescription() {
        return "Installing FML libraries";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<MojangVersion> queue) throws IOException, InterruptedException {
        String minecraft = this.modpack.getGameVersion();
        Map<String, String> fmlLibs = FmlLibsManager.getLibsForVersion(minecraft);
        if (fmlLibs.isEmpty()) {
            return;
        }
        File modpackFmlLibDir = new File(this.pack.getInstalledDirectory(), "lib");
        File fmlLibsCache = new File(this.directories.getCacheDirectory(), "fmllibs");
        Files.createDirectories(fmlLibsCache.toPath(), new FileAttribute[0]);
        fmlLibs.forEach((name, sha1) -> {
            SHA1FileVerifier verifier = null;
            if (!sha1.isEmpty()) {
                verifier = new SHA1FileVerifier((String)sha1);
            }
            File cached = new File(fmlLibsCache, (String)name);
            File target = new File(modpackFmlLibDir, (String)name);
            if (!target.exists() || verifier != null && !verifier.isFileValid(target)) {
                EnsureFileTask<MojangVersion> ensureFileTask = new EnsureFileTask<MojangVersion>(this.downloadLibraryQueue, cached).withUrl(TechnicConstants.TECHNIC_FML_LIB_REPO + name).withVerifier(verifier);
                this.verifyingFiles.addTask(ensureFileTask);
                this.copyLibraryQueue.addTask(new CopyFileTask(cached, target));
            }
        });
    }
}

