/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.ListenerTask;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.io.GameDownloads;
import net.technicpack.utilslib.Utils;

public class InstallMinecraftIfNecessaryTask
extends ListenerTask<MojangVersion> {
    private ModpackModel pack;
    private String minecraftVersion;
    private File cacheDirectory;
    private boolean forceRegeneration;

    public InstallMinecraftIfNecessaryTask(ModpackModel pack, String minecraftVersion, File cacheDirectory, boolean forceRegeneration) {
        this.pack = pack;
        this.minecraftVersion = minecraftVersion;
        this.cacheDirectory = cacheDirectory;
        this.forceRegeneration = forceRegeneration;
    }

    @Override
    public String getTaskDescription() {
        return "Installing Minecraft";
    }

    @Override
    public void runTask(InstallTasksQueue<MojangVersion> queue) throws IOException, InterruptedException {
        File binMinecraftJar;
        super.runTask(queue);
        MojangVersion version = queue.getMetadata();
        GameDownloads dls = version.getDownloads();
        if (dls == null) {
            throw new RuntimeException("Using legacy Minecraft download! Version id = " + version.getId() + "; parent = " + version.getParentVersion());
        }
        String url = dls.forClient().getUrl();
        SHA1FileVerifier verifier = new SHA1FileVerifier(dls.forClient().getSha1());
        File cache = new File(this.cacheDirectory, "minecraft_" + this.minecraftVersion + ".jar");
        boolean regenerate = this.forceRegeneration;
        if (!cache.exists() || !verifier.isFileValid(cache)) {
            String output = this.pack.getCacheDir() + File.separator + "minecraft.jar";
            Utils.downloadFile(url, cache.getName(), output, cache, verifier, this);
            regenerate = true;
        }
        if (!(binMinecraftJar = new File(this.pack.getBinDir(), "minecraft.jar")).exists() || regenerate) {
            MojangUtils.copyMinecraftJar(cache, binMinecraftJar, this);
        }
    }
}

