/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.IOException;
import net.technicpack.launchercore.exception.PackNotAvailableOfflineException;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.MojangVersionBuilder;

public class VerifyVersionFilePresentTask
implements IInstallTask<MojangVersion> {
    private MojangVersionBuilder builder;
    private String minecraftVersion;
    private ModpackModel modpack;

    public VerifyVersionFilePresentTask(ModpackModel modpack, String minecraftVersion, MojangVersionBuilder builder) {
        this.builder = builder;
        this.minecraftVersion = minecraftVersion;
        this.modpack = modpack;
    }

    @Override
    public String getTaskDescription() {
        return "Retrieving Modpack Version";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<MojangVersion> queue) throws IOException, InterruptedException {
        MojangVersion version = this.builder.buildVersionFromKey(this.minecraftVersion);
        if (version == null && this.modpack.isLocalOnly()) {
            throw new PackNotAvailableOfflineException(this.modpack.getDisplayName());
        }
    }
}

