/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.launch;

import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.launch.LaunchCommandCollector;
import net.technicpack.minecraftcore.launch.WindowType;

public class LaunchOptions {
    private String title;
    private String iconPath;
    private ILaunchOptions options;

    public LaunchOptions(String title, String iconPath, ILaunchOptions options) {
        this.options = options;
        this.title = title;
        this.iconPath = iconPath;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public ILaunchOptions getOptions() {
        return this.options;
    }

    public void appendToCommands(LaunchCommandCollector commands) {
        if (this.getTitle() != null) {
            commands.addUnique("--title", this.title);
        }
        if (this.options.getLaunchWindowType() == WindowType.FULLSCREEN) {
            commands.addUnique("--fullscreen");
        } else if (this.options.getLaunchWindowType() == WindowType.CUSTOM) {
            commands.addUnique("--width", Integer.toString(this.options.getCustomWidth()));
            commands.addUnique("--height", Integer.toString(this.options.getCustomHeight()));
        }
        if (this.getIconPath() != null) {
            commands.addUnique("--icon", this.getIconPath());
        }
    }
}

