/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.launch;

import io.sentry.Sentry;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import net.technicpack.autoupdate.IBuildNumber;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.auth.UserModel;
import net.technicpack.launchercore.exception.InstallException;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.launchercore.launch.GameProcess;
import net.technicpack.launchercore.launch.ProcessExitListener;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.RunData;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.launch.LaunchCommandCollector;
import net.technicpack.minecraftcore.launch.LaunchOptions;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.io.Library;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentList;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.ProcessUtils;
import net.technicpack.utilslib.Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;

public class MinecraftLauncher {
    private final LauncherDirectories directories;
    private final IPlatformApi platformApi;
    private final UserModel userModel;
    private final JavaVersionRepository javaVersions;
    private final IBuildNumber buildNumber;

    public MinecraftLauncher(IPlatformApi platformApi, LauncherDirectories directories, UserModel userModel, JavaVersionRepository javaVersions, IBuildNumber buildNumber) {
        this.directories = directories;
        this.platformApi = platformApi;
        this.userModel = userModel;
        this.javaVersions = javaVersions;
        this.buildNumber = buildNumber;
    }

    public JavaVersionRepository getJavaVersions() {
        return this.javaVersions;
    }

    public GameProcess launch(ModpackModel pack, long memory, LaunchOptions options, ProcessExitListener exitListener, MojangVersion version) throws IOException, InstallException {
        List<String> commands = this.buildCommands(pack, memory, version, options);
        String userAccessToken = this.userModel.getCurrentUser().getAccessToken();
        String commandStr = String.join((CharSequence)" ", commands);
        if (!userAccessToken.equals("0")) {
            commandStr = commandStr.replace(userAccessToken, "USER_ACCESS_TOKEN");
        }
        Utils.getLogger().info("Running " + commandStr);
        ProcessBuilder processBuilder = ProcessUtils.createProcessBuilder(commands).directory(pack.getInstalledDirectory()).redirectErrorStream(true);
        Process process = processBuilder.start();
        GameProcess mcProcess = new GameProcess(process, userAccessToken);
        if (exitListener != null) {
            mcProcess.setExitListener(exitListener);
        }
        this.platformApi.incrementPackRuns(pack.getName());
        if (!Utils.sendTracking("runModpack", pack.getName(), pack.getInstalledVersion().getVersion(), options.getOptions().getClientId())) {
            Utils.getLogger().info("Failed to record event");
        }
        return mcProcess;
    }

    private List<String> buildCommands(ModpackModel pack, long memory, MojangVersion version, LaunchOptions options) throws InstallException {
        ArgumentList jvmArgs;
        LaunchCommandCollector commands = new LaunchCommandCollector();
        String wrapperCommand = options.getOptions().getWrapperCommand();
        if (StringUtils.isNotEmpty(wrapperCommand)) {
            commands.addRaw(wrapperCommand);
        }
        IJavaRuntime javaRuntime = version.getJavaRuntime();
        commands.addRaw(javaRuntime.getExecutableFile().toString());
        OperatingSystem operatingSystem = OperatingSystem.getOperatingSystem();
        String nativesDir = new File(pack.getBinDir(), "natives").getAbsolutePath();
        ILaunchOptions launchOpts = options.getOptions();
        String cpString = this.buildClassPath(pack, version, launchOpts);
        Utils.getLogger().log(Level.FINE, String.format("Classpath:%n%n%s", cpString.replace(File.pathSeparatorChar, '\n')));
        StringSubstitutor paramDereferencer = this.createParamDereferencer(pack, version, nativesDir, cpString, launchOpts);
        String customJvmArgs = options.getOptions().getJavaArgs();
        if (StringUtils.isNotEmpty(customJvmArgs)) {
            customJvmArgs = customJvmArgs.replaceAll("[\\r\\n]", " ");
            for (String customJvmArg : customJvmArgs.split(" +")) {
                commands.addRaw(customJvmArg);
            }
        }
        String launchJavaVersion = javaRuntime.getVersion();
        if (!MojangUtils.hasModernMinecraftForge(version) && !MojangUtils.hasNeoForge(version) && (jvmArgs = version.getJavaArguments()) != null) {
            for (String arg : jvmArgs.resolve(options.getOptions(), javaRuntime, paramDereferencer)) {
                commands.add(arg);
            }
        }
        commands.addRaw("-Xms" + memory + "m");
        commands.addRaw("-Xmx" + memory + "m");
        if (!RunData.isJavaVersionAtLeast(launchJavaVersion, "1.8")) {
            int permSize = 128;
            if (memory >= 6144L) {
                permSize = 512;
            } else if (memory >= 2048L) {
                permSize = 256;
            }
            commands.add("-XX:MaxPermSize=" + permSize + "m");
        }
        commands.addUnique("-Djava.library.path=" + nativesDir);
        commands.addUnique("-Dfml.ignoreInvalidMinecraftCertificates=true");
        commands.addUnique("-Dfml.ignorePatchDiscrepancies=true");
        if (MojangUtils.requiresForgeWrapper(version)) {
            commands.addUnique("-Dforgewrapper.librariesDir=" + this.directories.getCacheDirectory().getAbsolutePath());
            File modpackJar = new File(pack.getBinDir(), "modpack.jar");
            commands.addUnique("-Dforgewrapper.installer=" + modpackJar.getAbsolutePath());
            String mcVersion = MojangUtils.getMinecraftVersion(version);
            File minecraftJar = new File(this.directories.getCacheDirectory(), "minecraft_" + mcVersion + ".jar");
            commands.addUnique("-Dforgewrapper.minecraft=" + minecraftJar.getAbsolutePath());
        }
        commands.addUnique("-Dminecraft.applet.TargetDirectory=" + pack.getInstalledDirectory().getAbsolutePath());
        commands.addUnique("-Duser.language=en");
        if (!options.getOptions().shouldUseStencilBuffer()) {
            commands.add("-Dforge.forceNoStencil=true");
        }
        if (operatingSystem.equals((Object)OperatingSystem.OSX)) {
            commands.add("-Xdock:icon=" + options.getIconPath());
            commands.add("-Xdock:name=" + pack.getDisplayName());
            boolean hasLwjgl3 = version.getLibrariesForCurrentOS(launchOpts, javaRuntime).stream().anyMatch(library -> library.getName().startsWith("org.lwjgl:lwjgl:"));
            if (hasLwjgl3) {
                commands.addUnique("-XstartOnFirstThread");
            }
        } else if (operatingSystem.equals((Object)OperatingSystem.WINDOWS)) {
            commands.addUnique("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump");
        }
        commands.addUnique("-cp", cpString);
        commands.addRaw(version.getMainClass());
        List<String> mcArgs = version.getMinecraftArguments().resolve(launchOpts, javaRuntime, paramDereferencer);
        ListIterator<String> mcArgsIterator = mcArgs.listIterator();
        while (mcArgsIterator.hasNext()) {
            String current = mcArgsIterator.next();
            String next = mcArgsIterator.hasNext() ? mcArgs.get(mcArgsIterator.nextIndex()) : null;
            if (current.startsWith("--")) {
                if (next != null && !next.startsWith("--")) {
                    if (current.equals("--tweakClass")) {
                        commands.add(current, next);
                    } else {
                        commands.addUnique(current, next);
                    }
                    mcArgsIterator.next();
                    continue;
                }
                commands.addUnique(current);
                continue;
            }
            commands.add(current);
        }
        options.appendToCommands(commands);
        return commands.collect();
    }

    private StringSubstitutor createParamDereferencer(ModpackModel pack, MojangVersion version, String nativesDir, String cpString, ILaunchOptions launchOpts) {
        HashMap<String, String> params = new HashMap<String, String>();
        IUserType user = this.userModel.getCurrentUser();
        File gameDirectory = pack.getInstalledDirectory();
        params.put("auth_username", user.getUsername());
        params.put("auth_session", user.getSessionId());
        params.put("auth_access_token", user.getAccessToken());
        params.put("auth_player_name", user.getDisplayName());
        params.put("auth_uuid", user.getId());
        params.put("profile_name", user.getDisplayName());
        params.put("version_name", version.getId());
        params.put("version_type", version.getType().getName());
        params.put("game_directory", gameDirectory.getAbsolutePath());
        params.put("natives_directory", nativesDir);
        params.put("classpath", cpString);
        params.put("resolution_width", Integer.toString(launchOpts.getCustomWidth()));
        params.put("resolution_height", Integer.toString(launchOpts.getCustomHeight()));
        String targetAssets = this.directories.getAssetsDirectory().getAbsolutePath();
        String assetsKey = version.getAssetsKey();
        if (assetsKey == null || assetsKey.isEmpty()) {
            assetsKey = "legacy";
        }
        if (version.getAreAssetsVirtual()) {
            targetAssets = targetAssets + File.separator + "virtual" + File.separator + assetsKey;
        } else if (version.getAssetsMapToResources()) {
            targetAssets = pack.getResourcesDir().getAbsolutePath();
        }
        params.put("game_assets", targetAssets);
        params.put("assets_root", targetAssets);
        params.put("assets_index_name", assetsKey);
        params.put("user_type", user.getMCUserType());
        params.put("user_properties", user.getUserProperties());
        params.put("launcher_name", "technic");
        params.put("launcher_version", "4." + this.buildNumber.getBuildNumber());
        return new StringSubstitutor(params);
    }

    private String buildClassPath(ModpackModel pack, MojangVersion version, ILaunchOptions launchOptions) throws InstallException {
        File minecraft;
        File modpack;
        StringBuilder sb = new StringBuilder(10000);
        char separator = File.pathSeparatorChar;
        IJavaRuntime runtime = version.getJavaRuntime();
        Sentry.addBreadcrumb(String.format("Runtime is %s", runtime));
        String bitness = runtime.getBitness();
        for (Library library : version.getLibrariesForCurrentOS(launchOptions, runtime)) {
            if (library.getNatives() != null) continue;
            File file = new File(this.directories.getCacheDirectory(), library.getArtifactPath().replace("${arch}", bitness));
            if (!file.isFile() || !file.exists()) {
                throw new InstallException("Library " + library.getName() + " not found.");
            }
            sb.append(file.getAbsolutePath()).append(separator);
        }
        boolean hasModernMinecraftForge = MojangUtils.hasModernMinecraftForge(version);
        boolean hasNeoForge = MojangUtils.hasNeoForge(version);
        if (!hasModernMinecraftForge && !hasNeoForge && (modpack = new File(pack.getBinDir(), "modpack.jar")).exists()) {
            sb.append(modpack.getAbsolutePath()).append(separator);
        }
        if (!(minecraft = hasModernMinecraftForge || hasNeoForge ? new File(this.directories.getCacheDirectory(), "minecraft_" + version.getParentVersion() + ".jar") : new File(pack.getBinDir(), "minecraft.jar")).exists()) {
            throw new RuntimeException("Minecraft not installed for this pack: " + pack);
        }
        sb.append(minecraft.getAbsolutePath());
        return sb.toString();
    }
}

