/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.chain;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.io.AssetIndex;
import net.technicpack.minecraftcore.mojang.version.io.GameDownloads;
import net.technicpack.minecraftcore.mojang.version.io.Library;
import net.technicpack.minecraftcore.mojang.version.io.ReleaseType;
import net.technicpack.minecraftcore.mojang.version.io.Rule;
import net.technicpack.minecraftcore.mojang.version.io.VersionJavaInfo;
import net.technicpack.minecraftcore.mojang.version.io.argument.Argument;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentList;

public class VersionChain
implements MojangVersion {
    private List<MojangVersion> chain = new LinkedList<MojangVersion>();

    public VersionChain(MojangVersion rootVersion) {
        this.chain.add(rootVersion);
    }

    @Override
    public String getId() {
        return this.chain.get(0).getId();
    }

    @Override
    public ReleaseType getType() {
        return this.chain.get(0).getType();
    }

    @Override
    public void setType(ReleaseType releaseType) {
        this.chain.get(0).setType(releaseType);
    }

    @Override
    public Date getUpdatedTime() {
        return this.chain.get(0).getUpdatedTime();
    }

    @Override
    public void setUpdatedTime(Date updatedTime) {
        this.chain.get(0).setUpdatedTime(updatedTime);
    }

    @Override
    public Date getReleaseTime() {
        return this.chain.get(0).getReleaseTime();
    }

    @Override
    public void setReleaseTime(Date releaseTime) {
        this.chain.get(0).setReleaseTime(releaseTime);
    }

    @Override
    public ArgumentList getMinecraftArguments() {
        ArgumentList.Builder allArguments = new ArgumentList.Builder();
        for (MojangVersion version : this.chain) {
            if (version.getMinecraftArguments() == null) continue;
            for (Argument arg : version.getMinecraftArguments().getArguments()) {
                allArguments.addArgument(arg);
            }
        }
        return allArguments.build();
    }

    @Override
    public ArgumentList getJavaArguments() {
        ArgumentList.Builder allArguments = new ArgumentList.Builder();
        for (MojangVersion version : this.chain) {
            if (version.getJavaArguments() == null) continue;
            for (Argument arg : version.getJavaArguments().getArguments()) {
                allArguments.addArgument(arg);
            }
        }
        return allArguments.build();
    }

    @Override
    public List<Library> getLibraries() {
        LinkedList<Library> allLibraries = new LinkedList<Library>();
        for (MojangVersion version : this.chain) {
            if (version.getLibraries() == null) continue;
            allLibraries.addAll(0, version.getLibraries());
        }
        return allLibraries.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<Library> getLibrariesForCurrentOS(ILaunchOptions options, IJavaRuntime runtime) {
        LinkedList<Library> allLibraries = new LinkedList<Library>();
        for (int i = this.chain.size() - 1; i >= 0; --i) {
            MojangVersion version = this.chain.get(i);
            List<Library> librariesForCurrentOS = version.getLibrariesForCurrentOS(options, runtime);
            if (librariesForCurrentOS == null) continue;
            allLibraries.addAll(0, librariesForCurrentOS);
        }
        return allLibraries.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public String getMainClass() {
        for (MojangVersion version : this.chain) {
            if (version.getMainClass() == null) continue;
            return version.getMainClass();
        }
        return null;
    }

    @Override
    public void setMainClass(String mainClass) {
        this.chain.get(0).setMainClass(mainClass);
    }

    @Override
    public int getMinimumLauncherVersion() {
        return this.chain.get(0).getMinimumLauncherVersion();
    }

    @Override
    public String getIncompatibilityReason() {
        for (MojangVersion version : this.chain) {
            if (version.getIncompatibilityReason() == null) continue;
            return version.getIncompatibilityReason();
        }
        return null;
    }

    @Override
    public List<Rule> getRules() {
        LinkedList<Rule> allRules = new LinkedList<Rule>();
        for (MojangVersion version : this.chain) {
            if (version.getRules() == null) continue;
            allRules.addAll(0, version.getRules());
        }
        return allRules;
    }

    @Override
    public AssetIndex getAssetIndex() {
        for (MojangVersion version : this.chain) {
            if (version.getAssetIndex() == null) continue;
            return version.getAssetIndex();
        }
        return null;
    }

    @Override
    public String getAssetsKey() {
        for (MojangVersion version : this.chain) {
            if (version.getAssetsKey() == null) continue;
            return version.getAssetsKey();
        }
        return null;
    }

    @Override
    public GameDownloads getDownloads() {
        for (MojangVersion version : this.chain) {
            if (version.getDownloads() == null) continue;
            return version.getDownloads();
        }
        return null;
    }

    @Override
    public boolean getAreAssetsVirtual() {
        return this.chain.get(0).getAreAssetsVirtual();
    }

    @Override
    public void setAreAssetsVirtual(boolean areAssetsVirtual) {
        this.chain.get(0).setAreAssetsVirtual(areAssetsVirtual);
    }

    @Override
    public boolean getAssetsMapToResources() {
        return this.chain.get(0).getAssetsMapToResources();
    }

    @Override
    public void setAssetsMapToResources(boolean mapToResources) {
        this.chain.get(0).setAssetsMapToResources(mapToResources);
    }

    @Override
    public String getParentVersion() {
        return this.chain.get(this.chain.size() - 1).getId();
    }

    @Override
    public void addLibrary(Library library) {
        this.chain.get(0).addLibrary(library);
    }

    @Override
    public void prependLibrary(Library library) {
        this.chain.get(0).prependLibrary(library);
    }

    @Override
    public VersionJavaInfo getMojangRuntimeInformation() {
        for (MojangVersion version : this.chain) {
            if (version.getMojangRuntimeInformation() == null) continue;
            return version.getMojangRuntimeInformation();
        }
        return null;
    }

    @Override
    public void removeLibrary(String libraryName) {
        for (MojangVersion version : this.chain) {
            version.removeLibrary(libraryName);
        }
    }

    @Override
    public IJavaRuntime getJavaRuntime() {
        for (MojangVersion version : this.chain) {
            if (version.getJavaRuntime() == null) continue;
            return version.getJavaRuntime();
        }
        return null;
    }

    @Override
    public void setJavaRuntime(IJavaRuntime runtime) {
        for (MojangVersion version : this.chain) {
            version.setJavaRuntime(runtime);
        }
    }

    public void addVersionToChain(MojangVersion version) {
        this.chain.add(version);
    }
}

