/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.io;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.mojang.version.MojangVersion;
import net.technicpack.minecraftcore.mojang.version.io.AssetIndex;
import net.technicpack.minecraftcore.mojang.version.io.GameDownloads;
import net.technicpack.minecraftcore.mojang.version.io.LaunchArguments;
import net.technicpack.minecraftcore.mojang.version.io.Library;
import net.technicpack.minecraftcore.mojang.version.io.ReleaseType;
import net.technicpack.minecraftcore.mojang.version.io.Rule;
import net.technicpack.minecraftcore.mojang.version.io.VersionJavaInfo;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentList;

public class CompleteVersionV21
implements MojangVersion,
Serializable {
    private String id;
    private Date time;
    private Date releaseTime;
    private ReleaseType type;
    private LaunchArguments arguments;
    private List<Library> libraries;
    private String mainClass;
    private int minimumLauncherVersion;
    private String incompatibilityReason;
    private List<Rule> rules;
    private String assets;
    private AssetIndex assetIndex;
    private GameDownloads downloads;
    private String inheritsFrom;
    private VersionJavaInfo javaVersion;
    private transient boolean areAssetsVirtual;
    private transient boolean mapToResources;
    private transient IJavaRuntime javaRuntime;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReleaseType getType() {
        return this.type;
    }

    @Override
    public void setType(ReleaseType type) {
        this.type = type;
    }

    @Override
    public Date getUpdatedTime() {
        return this.time;
    }

    @Override
    public void setUpdatedTime(Date updatedTime) {
        this.time = updatedTime;
    }

    @Override
    public Date getReleaseTime() {
        return this.releaseTime;
    }

    @Override
    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }

    @Override
    public ArgumentList getMinecraftArguments() {
        return this.arguments.getGameArgs();
    }

    @Override
    public ArgumentList getJavaArguments() {
        return this.arguments.getJvmArgs();
    }

    @Override
    public List<Library> getLibraries() {
        return this.libraries;
    }

    @Override
    public List<Library> getLibrariesForCurrentOS(ILaunchOptions options, IJavaRuntime runtime) {
        return this.libraries.stream().filter(x -> x.isForCurrentOS(options, runtime)).distinct().collect(Collectors.toList());
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    @Override
    public String getIncompatibilityReason() {
        return this.incompatibilityReason;
    }

    @Override
    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    public String getAssetsKey() {
        return this.assets;
    }

    @Override
    public AssetIndex getAssetIndex() {
        return this.assetIndex;
    }

    @Override
    public GameDownloads getDownloads() {
        return this.downloads;
    }

    @Override
    public String getParentVersion() {
        return this.inheritsFrom;
    }

    @Override
    public boolean getAreAssetsVirtual() {
        return this.areAssetsVirtual;
    }

    @Override
    public void setAreAssetsVirtual(boolean areAssetsVirtual) {
        this.areAssetsVirtual = areAssetsVirtual;
    }

    @Override
    public boolean getAssetsMapToResources() {
        return this.mapToResources;
    }

    @Override
    public void setAssetsMapToResources(boolean mapToResources) {
        this.mapToResources = mapToResources;
    }

    @Override
    public void addLibrary(Library library) {
        this.libraries.add(library);
    }

    @Override
    public void prependLibrary(Library library) {
        this.libraries.add(0, library);
    }

    @Override
    public VersionJavaInfo getMojangRuntimeInformation() {
        return this.javaVersion;
    }

    @Override
    public void removeLibrary(String libraryName) {
        this.libraries = this.libraries.stream().filter(library -> !library.getName().equals(libraryName)).collect(Collectors.toList());
    }

    @Override
    public IJavaRuntime getJavaRuntime() {
        return this.javaRuntime;
    }

    @Override
    public void setJavaRuntime(IJavaRuntime runtime) {
        this.javaRuntime = runtime;
    }

    public String toString() {
        return "CompleteVersionV21{id='" + this.id + '\'' + ", time=" + this.time + ", releaseTime=" + this.releaseTime + ", type=" + (Object)((Object)this.type) + ", arguments='" + this.arguments + '\'' + ", libraries=" + this.libraries + ", mainClass='" + this.mainClass + '\'' + ", minimumLauncherVersion=" + this.minimumLauncherVersion + ", incompatibilityReason='" + this.incompatibilityReason + '\'' + ", rules=" + this.rules + '}';
    }
}

