/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.io;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.technicpack.launchercore.TechnicConstants;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.mojang.version.io.Artifact;
import net.technicpack.minecraftcore.mojang.version.io.Downloads;
import net.technicpack.minecraftcore.mojang.version.io.ExtractRules;
import net.technicpack.minecraftcore.mojang.version.io.Rule;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.Utils;

public class Library {
    private static final String[] FALLBACK = new String[]{"https://libraries.minecraft.net/", "https://maven.minecraftforge.net/", "https://mirror.technicpack.net/Technic/lib/", "https://maven.creeperhost.net/"};
    private static final Pattern GRADLE_PATTERN = Pattern.compile("^([^:@]+):([^:@]+):([^:@]+)(?::([^:@]+))?(?:@([^:@]+))?$");
    private static final Pattern FORGE_MAVEN_ROOT = Pattern.compile("^https://(?:files\\.minecraftforge\\.net/maven|maven\\.minecraftforge\\.net)/(.+)$");
    private static final String MCFORGE_MAVEN_MIRROR = "https://maven.creeperhost.net/";
    private String name;
    private List<Rule> rules;
    private Downloads downloads;
    private Map<OperatingSystem, String> natives;
    private ExtractRules extract;
    private String url;
    private transient String gradleGroupId;
    private transient String gradleArtifactId;
    private transient String gradleVersion;
    private transient String gradleClassifier;
    private transient String gradleExtension;

    public String getNormalizedName() {
        return this.name.contains("@") ? this.name : this.name + "@jar";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Library library = (Library)o;
        this.ensureNameIsParsed();
        library.ensureNameIsParsed();
        return Objects.equals(this.gradleGroupId, library.gradleGroupId) && Objects.equals(this.gradleArtifactId, library.gradleArtifactId) && Objects.equals(this.gradleClassifier, library.gradleClassifier) && Objects.equals(this.gradleExtension, library.gradleExtension) && Objects.equals(this.rules, library.rules) && Objects.equals(this.natives, library.natives);
    }

    public int hashCode() {
        this.ensureNameIsParsed();
        return Objects.hash(this.gradleGroupId, this.gradleArtifactId, this.gradleClassifier, this.gradleExtension, this.rules, this.natives);
    }

    public Library() {
    }

    public Library(String name) {
        this.setName(name);
    }

    public Library(String name, String artifactUrl, String artifactSha1, int artifactSize) {
        this.setName(name);
        this.downloads = new Downloads(artifactUrl, artifactSha1, artifactSize);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.parseName();
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Map<OperatingSystem, String> getNatives() {
        return this.natives;
    }

    public ExtractRules getExtract() {
        return this.extract;
    }

    private void ensureNameIsParsed() {
        if (this.gradleGroupId != null) {
            return;
        }
        this.parseName();
    }

    private void parseName() {
        Matcher m = GRADLE_PATTERN.matcher(this.name);
        if (!m.matches()) {
            throw new IllegalStateException("Cannot parse invalid gradle specifier: " + this.name);
        }
        this.gradleGroupId = m.group(1);
        this.gradleArtifactId = m.group(2);
        this.gradleVersion = m.group(3);
        this.gradleClassifier = m.group(4);
        String extension = m.group(5);
        this.gradleExtension = extension != null && !extension.isEmpty() ? extension : "jar";
    }

    public String getGradleGroup() {
        this.ensureNameIsParsed();
        return this.gradleGroupId;
    }

    public String getGradleArtifact() {
        this.ensureNameIsParsed();
        return this.gradleArtifactId;
    }

    public String getGradleVersion() {
        this.ensureNameIsParsed();
        return this.gradleVersion;
    }

    public String getGradleClassifier() {
        this.ensureNameIsParsed();
        return this.gradleClassifier;
    }

    public boolean isForCurrentOS(ILaunchOptions options, IJavaRuntime runtime) {
        if (this.rules == null) {
            return true;
        }
        return Rule.isAllowable(this.rules, options, runtime);
    }

    public boolean hasNatives() {
        return this.natives != null && !this.natives.isEmpty();
    }

    public String getArtifactPath() {
        return this.getArtifactPath(null);
    }

    public String getArtifactPath(String nativeClassifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact path of empty/blank artifact");
        }
        this.ensureNameIsParsed();
        String filename = this.getArtifactFilename(nativeClassifier);
        return this.gradleGroupId.replace('.', '/') + '/' + this.gradleArtifactId + '/' + this.gradleVersion + '/' + filename;
    }

    public String getArtifactFilename(String nativeClassifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact filename of empty/blank artifact");
        }
        this.ensureNameIsParsed();
        String filename = this.gradleArtifactId + '-' + this.gradleVersion;
        if (nativeClassifier != null) {
            filename = filename + '-' + nativeClassifier;
        } else if (this.gradleClassifier != null && !this.gradleClassifier.isEmpty()) {
            filename = filename + '-' + this.gradleClassifier;
        }
        filename = filename + '.' + this.gradleExtension;
        return filename;
    }

    public String getArtifactSha1(String nativeClassifier) {
        if (this.downloads == null) {
            return null;
        }
        Artifact artifact = nativeClassifier != null ? this.downloads.getClassifier(nativeClassifier) : this.downloads.getArtifact();
        if (artifact != null) {
            return artifact.getSha1();
        }
        return null;
    }

    public String getDownloadUrl(String path) throws DownloadException {
        LinkedHashSet<String> possibleUrls = new LinkedHashSet<String>(8);
        if (this.url != null) {
            possibleUrls.add(this.url + path);
        }
        if (!this.hasNatives()) {
            Artifact artifact;
            String artifactUrl = null;
            if (this.downloads != null && (artifact = this.downloads.getArtifact()) != null) {
                artifactUrl = artifact.getUrl();
            }
            if (artifactUrl != null && !artifactUrl.isEmpty()) {
                Matcher m = FORGE_MAVEN_ROOT.matcher(artifactUrl);
                if (m.matches()) {
                    possibleUrls.add(TechnicConstants.TECHNIC_LIB_REPO + m.group(1));
                    possibleUrls.add(MCFORGE_MAVEN_MIRROR + m.group(1));
                }
                possibleUrls.add(artifactUrl);
            }
        }
        for (String string : FALLBACK) {
            possibleUrls.add(string + path);
        }
        for (String possibleUrl : possibleUrls) {
            if (!Utils.pingHttpURL(possibleUrl)) continue;
            return possibleUrl;
        }
        throw new DownloadException("Failed to download library " + path + ": no mirror found");
    }

    public boolean isMinecraftForge() {
        return this.name.startsWith("net.minecraftforge:forge:") || this.name.startsWith("net.minecraftforge:minecraftforge:");
    }

    public boolean isLog4j() {
        return this.name.startsWith("org.apache.logging.log4j:");
    }

    public Downloads getDownloads() {
        return this.downloads;
    }

    public void setDownloads(Downloads downloads) {
        this.downloads = downloads;
    }
}

