/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.io.argument;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.mojang.version.io.argument.Argument;
import org.apache.commons.text.StringSubstitutor;

public class ArgumentList {
    private final List<Argument> args;

    private ArgumentList(List<Argument> args) {
        this.args = Collections.unmodifiableList(args);
    }

    public static ArgumentList fromString(String args) {
        if (args == null) {
            return null;
        }
        Builder argsBuilder = new Builder();
        for (String arg : args.split(" ")) {
            argsBuilder.addArgument(Argument.literal(arg));
        }
        return argsBuilder.build();
    }

    public List<Argument> getArguments() {
        return this.args;
    }

    public List<String> resolve(ILaunchOptions opts, IJavaRuntime runtime, StringSubstitutor derefs) {
        ArrayList<String> resolved = new ArrayList<String>();
        if (derefs == null) {
            derefs = new StringSubstitutor();
        }
        for (Argument arg : this.args) {
            if (!arg.doesApply(opts, runtime)) continue;
            for (String argStr : arg.getArgStrings()) {
                resolved.add(derefs.replace(argStr));
            }
        }
        return resolved;
    }

    public JsonElement serialize() {
        JsonArray json = new JsonArray();
        for (Argument arg : this.args) {
            json.add(arg.serialize());
        }
        return json;
    }

    public static class Builder {
        private final List<Argument> args = new ArrayList<Argument>();

        public void addArgument(Argument arg) {
            this.args.add(arg);
        }

        public ArgumentList build() {
            return new ArgumentList(this.args);
        }
    }
}

