/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.io.argument;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.mojang.version.io.Rule;
import net.technicpack.minecraftcore.mojang.version.io.argument.Argument;

public class PredicatedArgument
extends Argument {
    private final List<Rule> rules;
    private final Argument value;

    public PredicatedArgument(List<Rule> rules, Argument value) {
        this.rules = rules;
        this.value = value;
    }

    @Override
    public boolean doesApply(ILaunchOptions opts, IJavaRuntime runtime) {
        return Rule.isAllowable(this.rules, opts, runtime);
    }

    @Override
    public List<String> getArgStrings() {
        return this.value.getArgStrings();
    }

    @Override
    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        JsonArray serializedRules = new JsonArray();
        for (Rule rule : this.rules) {
            serializedRules.add(rule.serialize());
        }
        json.add("rules", serializedRules);
        json.add("value", this.value.serialize());
        return json;
    }
}

