/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.platform.packsources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.technicpack.launchercore.modpacks.sources.IPackSource;
import net.technicpack.platform.IPlatformSearchApi;
import net.technicpack.platform.io.SearchResult;
import net.technicpack.platform.io.SearchResultsData;
import net.technicpack.platform.packsources.SearchResultPackInfo;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.rest.io.PackInfo;

public class SearchResultPackSource
implements IPackSource {
    private IPlatformSearchApi platformApi;
    private String searchTerms;
    private Map<String, Integer> resultPriorities = new HashMap<String, Integer>();

    public SearchResultPackSource(IPlatformSearchApi platformApi, String searchTerms) {
        this.platformApi = platformApi;
        this.searchTerms = searchTerms;
    }

    @Override
    public String getSourceName() {
        return "Modpack search results for query '" + this.searchTerms + "'";
    }

    @Override
    public Collection<PackInfo> getPublicPacks() {
        SearchResultsData results;
        this.resultPriorities.clear();
        try {
            results = this.platformApi.getSearchResults(this.searchTerms);
        }
        catch (RestfulAPIException ex) {
            return Collections.emptySet();
        }
        ArrayList<PackInfo> resultPacks = new ArrayList<PackInfo>(results.getResults().length);
        int priority = 100;
        for (SearchResult result : results.getResults()) {
            resultPacks.add(new SearchResultPackInfo(result));
            this.resultPriorities.put(result.getSlug(), priority--);
        }
        return resultPacks;
    }

    @Override
    public int getPriority(PackInfo info) {
        if (this.resultPriorities.containsKey(info.getName())) {
            return this.resultPriorities.get(info.getName());
        }
        return 0;
    }
}

