/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.solder;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import net.technicpack.launchercore.modpacks.sources.IPackSource;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.rest.io.PackInfo;
import net.technicpack.solder.ISolderApi;
import net.technicpack.solder.io.SolderPackInfo;
import net.technicpack.utilslib.Utils;

public class SolderPackSource
implements IPackSource {
    private String baseUrl;
    private ISolderApi solder;

    public SolderPackSource(String baseUrl, ISolderApi solder) {
        this.baseUrl = baseUrl;
        this.solder = solder;
    }

    @Override
    public String getSourceName() {
        return "Public packs for solder " + this.baseUrl;
    }

    @Override
    public Collection<PackInfo> getPublicPacks() {
        LinkedList<PackInfo> returnValue = new LinkedList<PackInfo>();
        try {
            Collection<SolderPackInfo> packs = this.solder.getPublicSolderPacks(this.baseUrl);
            returnValue.addAll(packs);
        }
        catch (RestfulAPIException ex) {
            Utils.getLogger().log(Level.WARNING, "Unable to load technic modpacks", ex);
        }
        return returnValue;
    }

    @Override
    public int getPriority(PackInfo pack) {
        return -1;
    }
}

