/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.solder.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.solder.ISolderApi;
import net.technicpack.solder.ISolderPackApi;
import net.technicpack.solder.cache.CachedSolderPackApi;
import net.technicpack.solder.io.SolderPackInfo;
import org.joda.time.DateTime;
import org.joda.time.Seconds;

public class CachedSolderApi
implements ISolderApi {
    private LauncherDirectories directories;
    private ISolderApi innerApi;
    private Collection<SolderPackInfo> cachedPublicPacks = null;
    private DateTime lastSolderPull = new DateTime(0L);
    private int cacheInSeconds;
    private Cache<CacheTuple, ISolderPackApi> packs;

    public CachedSolderApi(LauncherDirectories directories, ISolderApi innerApi, int cacheInSeconds) {
        this.directories = directories;
        this.innerApi = innerApi;
        this.cacheInSeconds = cacheInSeconds;
        this.packs = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(50L).expireAfterWrite(cacheInSeconds, TimeUnit.SECONDS).build();
    }

    @Override
    public ISolderPackApi getSolderPack(String solderRoot, String modpackSlug, String mirrorUrl) throws RestfulAPIException {
        CacheTuple tuple = new CacheTuple(solderRoot, modpackSlug, mirrorUrl);
        ISolderPackApi pack = this.packs.getIfPresent(tuple);
        if (pack == null) {
            pack = new CachedSolderPackApi(this.directories, this.innerApi.getSolderPack(solderRoot, modpackSlug, mirrorUrl), this.cacheInSeconds, modpackSlug);
            this.packs.put(tuple, pack);
        }
        return pack;
    }

    @Override
    public Collection<SolderPackInfo> getPublicSolderPacks(String solderRoot) throws RestfulAPIException {
        return this.internalGetPublicSolderPacks(solderRoot, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SolderPackInfo> internalGetPublicSolderPacks(String solderRoot, ISolderApi packFactory) throws RestfulAPIException {
        if (Seconds.secondsBetween(this.lastSolderPull, DateTime.now()).isLessThan(Seconds.seconds(this.cacheInSeconds)) && this.cachedPublicPacks != null) {
            return this.cachedPublicPacks;
        }
        if (Seconds.secondsBetween(this.lastSolderPull, DateTime.now()).isLessThan(Seconds.seconds(this.cacheInSeconds / 10))) {
            return new ArrayList<SolderPackInfo>(0);
        }
        try {
            Collection<SolderPackInfo> collection = this.cachedPublicPacks = this.innerApi.internalGetPublicSolderPacks(solderRoot, this);
            return collection;
        }
        finally {
            this.lastSolderPull = DateTime.now();
        }
    }

    @Override
    public String getMirrorUrl(String solderRoot) throws RestfulAPIException {
        return this.innerApi.getMirrorUrl(solderRoot);
    }

    private static class CacheTuple {
        private String root;
        private String slug;
        private String url;

        public CacheTuple(String root, String slug, String url) {
            this.root = root;
            this.slug = slug;
            this.url = url;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CacheTuple)) {
                return false;
            }
            if (!this.root.equals(((CacheTuple)obj).root)) {
                return false;
            }
            if (!this.slug.equals(((CacheTuple)obj).slug)) {
                return false;
            }
            return this.url.equals(((CacheTuple)obj).url);
        }

        public int hashCode() {
            int hash = this.root.hashCode();
            hash *= 31;
            hash += this.slug.hashCode();
            hash *= 31;
            return hash += this.url.hashCode();
        }
    }
}

