/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.solder.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import net.technicpack.launchercore.exception.BuildInaccessibleException;
import net.technicpack.launchercore.install.LauncherDirectories;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.rest.io.Modpack;
import net.technicpack.solder.ISolderPackApi;
import net.technicpack.solder.io.SolderPackInfo;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Seconds;

public class CachedSolderPackApi
implements ISolderPackApi {
    private LauncherDirectories directories;
    private ISolderPackApi innerApi;
    private int cacheInSeconds;
    private String packSlug;
    private SolderPackInfo rootInfoCache = null;
    private DateTime lastInfoAccess = new DateTime(0L);
    private Cache<String, Modpack> buildCache;
    private Cache<String, Boolean> deadBuildCache;

    public CachedSolderPackApi(LauncherDirectories directories, ISolderPackApi innerApi, int cacheInSeconds, String packSlug) {
        this.directories = directories;
        this.innerApi = innerApi;
        this.cacheInSeconds = cacheInSeconds;
        this.packSlug = packSlug;
        this.buildCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(cacheInSeconds, TimeUnit.SECONDS).build();
        this.deadBuildCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(cacheInSeconds / 10, TimeUnit.SECONDS).build();
    }

    @Override
    public String getMirrorUrl() {
        return this.innerApi.getMirrorUrl();
    }

    @Override
    public SolderPackInfo getPackInfoForBulk() throws RestfulAPIException {
        if (this.rootInfoCache != null) {
            return this.rootInfoCache;
        }
        this.loadForeverCache();
        if (this.rootInfoCache != null) {
            return this.rootInfoCache;
        }
        return this.pullAndCache();
    }

    @Override
    public SolderPackInfo getPackInfo() throws RestfulAPIException {
        if (Seconds.secondsBetween(this.lastInfoAccess, DateTime.now()).isLessThan(Seconds.seconds(this.cacheInSeconds)) && this.rootInfoCache != null) {
            return this.rootInfoCache;
        }
        try {
            return this.pullAndCache();
        }
        catch (RestfulAPIException ex) {
            ex.printStackTrace();
            return this.getPackInfoForBulk();
        }
    }

    private SolderPackInfo pullAndCache() throws RestfulAPIException {
        try {
            this.rootInfoCache = this.innerApi.getPackInfoForBulk();
            this.saveForeverCache(this.rootInfoCache);
            SolderPackInfo solderPackInfo = this.rootInfoCache;
            return solderPackInfo;
        }
        finally {
            this.lastInfoAccess = DateTime.now();
        }
    }

    private void loadForeverCache() {
        File cacheFile = new File(new File(new File(this.directories.getAssetsDirectory(), "packs"), this.packSlug), "soldercache.json");
        if (!cacheFile.exists()) {
            return;
        }
        try {
            String packCache = FileUtils.readFileToString(cacheFile, StandardCharsets.UTF_8);
            this.rootInfoCache = Utils.getGson().fromJson(packCache, SolderPackInfo.class);
            if (this.rootInfoCache != null) {
                this.rootInfoCache.setLocal();
                this.rootInfoCache.setSolder(this.innerApi);
            }
        }
        catch (JsonSyntaxException | IOException exception) {
            // empty catch block
        }
    }

    private void saveForeverCache(SolderPackInfo info) {
        File cacheFile = new File(new File(new File(this.directories.getAssetsDirectory(), "packs"), info.getName()), "soldercache.json");
        String packCache = Utils.getGson().toJson(info);
        try {
            FileUtils.writeStringToFile(cacheFile, packCache, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Modpack getPackBuild(String build) throws BuildInaccessibleException {
        Boolean isDead = this.deadBuildCache.getIfPresent(build);
        if (Boolean.TRUE.equals(isDead)) {
            return null;
        }
        Modpack modpack = this.buildCache.getIfPresent(build);
        if (modpack != null) {
            return modpack;
        }
        try {
            modpack = this.innerApi.getPackBuild(build);
            if (modpack != null) {
                this.buildCache.put(build, modpack);
            }
            Modpack modpack2 = modpack;
            this.deadBuildCache.put(build, modpack == null);
            return modpack2;
        }
        catch (Throwable throwable) {
            this.deadBuildCache.put(build, modpack == null);
            throw throwable;
        }
    }
}

