/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.solder.http;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.technicpack.rest.RestObject;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.solder.ISolderApi;
import net.technicpack.solder.ISolderPackApi;
import net.technicpack.solder.http.HttpSolderPackApi;
import net.technicpack.solder.io.FullModpacks;
import net.technicpack.solder.io.Solder;
import net.technicpack.solder.io.SolderPackInfo;

public class HttpSolderApi
implements ISolderApi {
    private String clientId;
    private final Map<String, String> mirrorUrls = new HashMap<String, String>();

    public HttpSolderApi(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public ISolderPackApi getSolderPack(String solderRoot, String modpackSlug, String mirrorUrl) throws RestfulAPIException {
        return new HttpSolderPackApi(solderRoot, modpackSlug, this.clientId, mirrorUrl);
    }

    @Override
    public Collection<SolderPackInfo> getPublicSolderPacks(String solderRoot) throws RestfulAPIException {
        return this.internalGetPublicSolderPacks(solderRoot, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMirrorUrl(String solderRoot) throws RestfulAPIException {
        Map<String, String> map = this.mirrorUrls;
        synchronized (map) {
            if (!this.mirrorUrls.containsKey(solderRoot)) {
                String allPacksUrl = solderRoot + "modpack";
                Solder solder = RestObject.getRestObject(Solder.class, allPacksUrl);
                this.mirrorUrls.put(solderRoot, solder.getMirrorUrl());
            }
            return this.mirrorUrls.get(solderRoot);
        }
    }

    @Override
    public Collection<SolderPackInfo> internalGetPublicSolderPacks(String solderRoot, ISolderApi packFactory) throws RestfulAPIException {
        LinkedList<SolderPackInfo> allPackApis = new LinkedList<SolderPackInfo>();
        String allPacksUrl = solderRoot + "modpack?include=full&cid=" + this.clientId;
        FullModpacks technic = RestObject.getRestObject(FullModpacks.class, allPacksUrl);
        for (SolderPackInfo info : technic.getModpacks().values()) {
            ISolderPackApi solder = packFactory.getSolderPack(solderRoot, info.getName(), technic.getMirrorUrl());
            info.setSolder(solder);
            allPackApis.add(info);
        }
        return allPackApis;
    }
}

