/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.components;

import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class LimitLinesDocumentListener
implements DocumentListener {
    private int maximumLines;
    private boolean isRemoving;

    public LimitLinesDocumentListener(int maximumLines) {
        this.setLimitLines(maximumLines);
        this.isRemoving = false;
    }

    public void setLimitLines(int maximumLines) {
        if (maximumLines < 1) {
            throw new IllegalArgumentException("Maximum lines must be greater than 0");
        }
        this.maximumLines = maximumLines;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.isRemoving) {
            this.isRemoving = true;
            SwingUtilities.invokeLater(() -> this.removeLines(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLines(DocumentEvent e) {
        try {
            Document document = e.getDocument();
            Element root = document.getDefaultRootElement();
            int excess = root.getElementCount() - this.maximumLines;
            if (excess > 0) {
                Element line = root.getElement(excess - 1);
                int end = line.getEndOffset();
                try {
                    document.remove(0, end);
                }
                catch (BadLocationException ble) {
                    System.out.println(ble);
                }
            }
        }
        finally {
            this.isRemoving = false;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

